/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.nio.ByteBuffer;
import uk.org.retep.annotations.Encoding;
import uk.org.retep.annotations.Service;
import uk.org.retep.util.nio.charset.AbstractCharset;
import uk.org.retep.util.nio.charset.Charset;

@Encoding(value={"ISO-8859-1", "iso-ir-100", "ISO_8859-1", "latin1", "l1", "IBM819", "cp819", "csISOLatin1", "819", "IBM-819", "ISO8859_1", "ISO_8859-1:1987", "ISO_8859_1", "8859_1", "ISO8859-1"})
@Service(value=Charset.class)
public class ISO_8859_1
extends AbstractCharset {
    @Override
    public char decode(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            return (char)buffer.get();
        }
        return '\uffff';
    }

    @Override
    public boolean encode(ByteBuffer buffer, char c) {
        if (buffer.hasRemaining()) {
            buffer.put((byte)(c < 255 ? c : 32));
            return true;
        }
        return false;
    }

    @Override
    public int size(char c) {
        return 1;
    }
}

