/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.nio.ByteBuffer;
import uk.org.retep.util.nio.charset.Charset;

public abstract class AbstractCharset
implements Charset {
    @Override
    public Charset getInstance() {
        return this;
    }

    @Override
    public boolean isValid(char c) {
        return c != '\uffff' && c != '\ufffe';
    }

    @Override
    public final boolean hasCharacter(ByteBuffer buffer) {
        return this.isValid(this.peek(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasCharacters(ByteBuffer buffer, int count) {
        int pos = buffer.position();
        try {
            for (int i = 0; i < count; ++i) {
                if (this.isValid(this.decode(buffer))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.position(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final char peek(ByteBuffer buffer) {
        int pos = buffer.position();
        try {
            char c = this.decode(buffer);
            return c;
        }
        finally {
            buffer.position(pos);
        }
    }

    @Override
    public final int size(char[] c) {
        return this.size(c, 0, c.length);
    }

    @Override
    public final int size(char[] c, int length) {
        return this.size(c, 0, length);
    }

    @Override
    public final int size(char[] c, int offset, int length) {
        int size = 0;
        int i = offset;
        for (int j = 0; j < length; ++j) {
            size += this.size(c[i++]);
        }
        return size;
    }

    private final boolean skip(ByteBuffer buffer, int length) {
        if (buffer.remaining() >= length) {
            buffer.position(buffer.position() + length);
            return true;
        }
        return false;
    }

    @Override
    public final boolean skip(ByteBuffer buffer, char[] c) {
        return this.skip(buffer, this.size(c));
    }

    @Override
    public final boolean skip(ByteBuffer buffer, char[] c, int length) {
        return this.skip(buffer, this.size(c, length));
    }

    @Override
    public final boolean skip(ByteBuffer buffer, char[] c, int offset, int length) {
        return this.skip(buffer, this.size(c, offset, length));
    }

    @Override
    public final boolean peek(ByteBuffer buffer, char[] c) {
        return this.peek(buffer, c, 0, c.length);
    }

    @Override
    public final boolean peek(ByteBuffer buffer, char[] c, int length) {
        return this.peek(buffer, c, 0, length);
    }

    @Override
    public final boolean peek(ByteBuffer buffer, char[] c, int offset, int length) {
        int pos = buffer.position();
        boolean valid = true;
        int p = offset;
        for (int l = 0; l < length && valid; ++l) {
            char d = this.decode(buffer);
            if (d < '\u0000') {
                valid = false;
                break;
            }
            c[p++] = d;
            --l;
        }
        buffer.position(pos);
        return valid;
    }

    @Override
    public final boolean read(ByteBuffer buffer, char[] c) {
        return this.read(buffer, c, 0, c.length);
    }

    @Override
    public final boolean read(ByteBuffer buffer, char[] c, int length) {
        return this.read(buffer, c, 0, length);
    }

    @Override
    public final boolean read(ByteBuffer buffer, char[] c, int offset, int length) {
        int pos = buffer.position();
        int p = offset;
        for (int l = 0; l < length; ++l) {
            char d = this.decode(buffer);
            if (d < '\u0000') {
                buffer.position(pos);
                return false;
            }
            c[p++] = d;
            --l;
        }
        return true;
    }

    @Override
    public final int write(ByteBuffer buffer, char[] c) {
        return this.write(buffer, c, 0, c.length);
    }

    @Override
    public final int write(ByteBuffer buffer, char[] c, int length) {
        return this.write(buffer, c, 0, length);
    }

    @Override
    public final int write(ByteBuffer buffer, char[] c, int offset, int length) {
        int s = 0;
        for (int i = 0; i < length && this.encode(buffer, c[offset + i]); ++i) {
            ++s;
        }
        return s;
    }
}

