/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import uk.org.retep.util.io.tar.TarArchiveTracker;
import uk.org.retep.util.io.tar.TarHeader;
import uk.org.retep.util.io.tar.WritableTar;

public class TarOutputStream
extends FilterOutputStream
implements WritableTar {
    private final TarArchiveTracker tracker = new TarArchiveTracker(this){

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            TarOutputStream.this.write(buffer);
        }
    };

    public TarOutputStream(OutputStream out) {
        super(out);
    }

    protected final void write(ByteBuffer buffer) throws IOException {
        int size = buffer.limit() - buffer.position();
        this.write(buffer.array(), buffer.position(), size);
    }

    @Override
    public void putNextEntry(TarHeader header) throws IOException {
        this.closeEntry();
        ByteBuffer buffer = header.allocateTarHeader();
        header.put(buffer);
        buffer.flip();
        this.write(buffer);
    }

    @Override
    public void closeEntry() throws IOException {
        this.tracker.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.tracker.closeArchive();
        this.flush();
        super.close();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.tracker.recordBytesWritten(len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.tracker.recordBytesWritten(1);
    }
}

