/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.nio.ByteBuffer;
import uk.org.retep.util.io.tar.TarHeaderType;
import uk.org.retep.util.string.StringUtils;

public abstract class TarHeader {
    private static final byte[] MAGIC = new byte[]{117, 115, 116, 97, 114, 0, 48, 48};
    private static final byte[] BLANK_CSUM = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private static final byte[] BLOCK_END = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int BLOCK_SIZE = 512;
    public static final int NAME_SIZE = 100;
    public static final int MODE_SIZE = 8;
    public static final int UID_SIZE = 8;
    public static final int GID_SIZE = 8;
    public static final int SIZE_SIZE = 12;
    public static final int MTIME_SIZE = 12;
    public static final int CHKSUM_SIZE = 8;
    public static final int LINKNAME_SIZE = 100;
    public static final int UNAME_SIZE = 32;
    public static final int GNAME_SIZE = 32;
    public static final int DEVMAJOR_SIZE = 8;
    public static final int DEVMINOR_SIZE = 8;
    public static final int PREFIX_SIZE = 155;
    protected String name;
    protected int mode;
    protected int uid;
    protected int gid;
    protected long size;
    protected long mtime;
    protected String chksum;
    protected String version;
    protected String linkname;
    protected String uname;
    protected String gname;
    protected int devmajor;
    protected int devminor;
    protected String prefix;
    protected TarHeader prevHeader;
    protected TarHeader succHeader;

    public abstract TarHeaderType getTarHeaderType();

    public void get(ByteBuffer buffer) {
        this.name = StringUtils.getC(buffer, 100);
        StringUtils.getC(buffer, 8);
        StringUtils.getC(buffer, 8);
        StringUtils.getC(buffer, 8);
        StringUtils.getC(buffer, 12);
        StringUtils.getC(buffer, 12);
        this.chksum = StringUtils.getC(buffer, 8);
        buffer.position(buffer.position() + MAGIC.length);
        this.linkname = StringUtils.getC(buffer, 100);
        buffer.position(buffer.position() + 8);
        this.uname = StringUtils.getC(buffer, 32);
        this.gname = StringUtils.getC(buffer, 32);
        StringUtils.getC(buffer, 8);
        StringUtils.getC(buffer, 8);
        this.prefix = StringUtils.getC(buffer, 155);
    }

    public void put(ByteBuffer buffer) {
        if (this.prevHeader != null) {
            this.prevHeader.put(buffer);
        }
        int start = buffer.position();
        StringUtils.putC(buffer, 100, this.name);
        StringUtils.putOctalLong(buffer, 8, this.mode);
        StringUtils.putOctalLong(buffer, 8, this.uid);
        StringUtils.putOctalLong(buffer, 8, this.gid);
        StringUtils.putOctalLong(buffer, 12, this.size, false);
        StringUtils.putOctalLong(buffer, 12, this.mtime, false);
        int cpos = buffer.position();
        buffer.put(BLANK_CSUM);
        this.getTarHeaderType().put(buffer);
        StringUtils.putC(buffer, 100, this.linkname);
        buffer.put(MAGIC);
        StringUtils.putC(buffer, 32, this.uname);
        StringUtils.putC(buffer, 32, this.gname);
        StringUtils.putOctalLong(buffer, 8, this.devmajor);
        StringUtils.putOctalLong(buffer, 8, this.devminor);
        StringUtils.putC(buffer, 155, this.prefix);
        buffer.put(BLOCK_END);
        this.checksum(buffer, start, buffer.position(), cpos);
        this.putAdditional(buffer);
        if (this.succHeader != null) {
            this.succHeader.put(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checksum(ByteBuffer buffer, int start, int end, int cpos) {
        int sum = 0;
        for (int i = start; i < end; ++i) {
            int v = buffer.get(i);
            sum += 0xFF & (v < 0 ? 256 + v : v);
        }
        int p = buffer.position();
        try {
            buffer.position(cpos);
            StringUtils.putOctalLong(buffer, 8, sum);
        }
        finally {
            buffer.position(p);
        }
    }

    public final TarHeader getPrevHeader() {
        return this.prevHeader;
    }

    public final void setPrevHeader(TarHeader prevHeader) {
        this.prevHeader = prevHeader;
    }

    public final TarHeader getSuccHeader() {
        return this.succHeader;
    }

    public final void setSuccHeader(TarHeader succHeader) {
        this.succHeader = succHeader;
    }

    protected void putAdditional(ByteBuffer buffer) {
    }

    protected int getAdditionalSize() {
        return 0;
    }

    public static int getBlockSize(int size) {
        return 512 * (1 + size / 512);
    }

    public int getTarHeaderSize() {
        int headerSize = 512 + this.getAdditionalSize();
        if (this.prevHeader != null) {
            headerSize += this.prevHeader.getTarHeaderSize();
        }
        if (this.succHeader != null) {
            headerSize += this.succHeader.getTarHeaderSize();
        }
        return headerSize;
    }

    public ByteBuffer allocateTarHeader() {
        return ByteBuffer.allocate(this.getTarHeaderSize());
    }

    protected final <T extends FileHeader> T chain() {
        return (T)((FileHeader)this);
    }

    public static abstract class FileHeader
    extends NamedHeader {
        public FileHeader(String name) {
            super(name);
        }

        public final int getDevmajor() {
            return this.devmajor;
        }

        public final <T extends FileHeader> T setDevmajor(int devmajor) {
            this.devmajor = devmajor;
            return this.chain();
        }

        public final int getDevminor() {
            return this.devminor;
        }

        public final <T extends FileHeader> T setDevminor(int devminor) {
            this.devminor = devminor;
            return this.chain();
        }

        public final int getGid() {
            return this.gid;
        }

        public final <T extends FileHeader> T setGid(int gid) {
            this.gid = gid;
            return this.chain();
        }

        public final String getGname() {
            return this.gname;
        }

        public final <T extends FileHeader> T setGname(String gname) {
            this.gname = gname;
            return this.chain();
        }

        public final int getMode() {
            return this.mode;
        }

        public final <T extends FileHeader> T setMode(int mode) {
            this.mode = mode;
            return this.chain();
        }

        public final long getMtime() {
            return this.mtime * 1000L;
        }

        public final <T extends FileHeader> T setMtime(long mtime) {
            this.mtime = mtime / 1000L;
            return this.chain();
        }

        public final long getSize() {
            return this.size;
        }

        public final <T extends FileHeader> T setSize(long size) {
            this.size = size;
            return this.chain();
        }

        public final int getUid() {
            return this.uid;
        }

        public final <T extends FileHeader> T setUid(int uid) {
            this.uid = uid;
            return this.chain();
        }

        public final String getUname() {
            return this.uname;
        }

        public final <T extends FileHeader> T setUname(String uname) {
            this.uname = uname;
            return this.chain();
        }
    }

    public static abstract class NamedHeader
    extends TarHeader {
        public NamedHeader(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }
}

