/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.nio.ByteBuffer;
import uk.org.retep.util.string.StringUtils;

public enum TarFormat {
    USTAR("ustar"),
    GNU("gnu");

    public static final int HEADER_OFFSET = 257;
    private static final int FIELD_SIZE = 6;
    private final String type;

    private TarFormat(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void put(ByteBuffer buffer) {
        StringUtils.putC(buffer, 6, this.type);
    }

    public static TarFormat valueOf(ByteBuffer buffer) {
        return TarFormat.valueOf(StringUtils.getC(buffer, 6).toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TarFormat valueOf(ByteBuffer buffer, int offset) {
        int p = buffer.position();
        try {
            buffer.position(offset);
            TarFormat tarFormat = TarFormat.valueOf(buffer);
            return tarFormat;
        }
        finally {
            buffer.position(p);
        }
    }
}

