/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.File;
import uk.org.retep.util.io.tar.GnuHeader;
import uk.org.retep.util.io.tar.StandardHeader;
import uk.org.retep.util.io.tar.TarHeader;

public class TarFactory {
    private TarFactory() {
    }

    public static TarHeader createHeader(File file) {
        return TarFactory.createHeader(file, file.getName());
    }

    public static TarHeader createHeader(File file, String fileName) {
        if (file.isFile()) {
            return TarFactory.createFile(fileName);
        }
        if (file.isDirectory()) {
            return TarFactory.createDirectory(fileName);
        }
        throw new IllegalArgumentException("Unknown file type " + file);
    }

    public static TarHeader.FileHeader createFile(String fileName) {
        StandardHeader.RegularFile hdr = new StandardHeader.RegularFile(fileName);
        if (fileName.length() > 100) {
            hdr.setPrevHeader(new GnuHeader.LongNameFile(fileName));
        }
        return hdr;
    }

    public static TarHeader.FileHeader createFile(File file) {
        return TarFactory.createFile(file, file.getName());
    }

    public static TarHeader.FileHeader createFile(File file, String fileName) {
        TarHeader.FileHeader hdr = TarFactory.createFile(fileName);
        ((TarHeader.FileHeader)hdr.setSize(file.length())).setMtime(file.lastModified());
        int mode = 32768;
        if (file.canRead()) {
            mode |= 0x124;
        }
        if (file.canWrite()) {
            mode |= 0x80;
        }
        if (file.canExecute()) {
            mode |= 0x49;
        }
        hdr.setMode(mode);
        String uname = System.getProperty("user.name");
        ((TarHeader.FileHeader)hdr.setUname(uname)).setGname(uname);
        return hdr;
    }

    public static TarHeader.NamedHeader createDirectory(String fileName) {
        return TarFactory.createDirectory(fileName, 0L);
    }

    public static TarHeader.NamedHeader createDirectory(String fileName, long time) {
        StandardHeader.Directory hdr = null;
        hdr = time > 0L ? new StandardHeader.Directory(fileName, time) : new StandardHeader.Directory(fileName);
        if (fileName.length() > 100) {
            hdr.setPrevHeader(new GnuHeader.LongNameFile(fileName));
        }
        return hdr;
    }

    public static TarHeader.NamedHeader createDirectory(File file) {
        return TarFactory.createDirectory(file.getName(), file.lastModified());
    }

    public static TarHeader createVolumeHeader(String name) {
        return new GnuHeader.VolumeHeader(name);
    }
}

