/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.IOException;
import java.nio.ByteBuffer;
import uk.org.retep.util.io.tar.WritableTar;

abstract class TarArchiveTracker {
    private final WritableTar tar;
    private final ByteBuffer paddingBuffer;
    private long bytesWritten;

    public TarArchiveTracker(WritableTar tar) {
        this.tar = tar;
        this.paddingBuffer = ByteBuffer.allocate(512);
        this.paddingBuffer.clear();
        while (this.paddingBuffer.hasRemaining()) {
            this.paddingBuffer.put((byte)0);
        }
    }

    public abstract void write(ByteBuffer var1) throws IOException;

    public void recordBytesWritten(int size) {
        this.bytesWritten += (long)size;
    }

    public void closeEntry() throws IOException {
        int padding = (int)(this.bytesWritten % 512L);
        if (padding > 0) {
            this.paddingBuffer.clear();
            this.paddingBuffer.position(padding);
            this.write(this.paddingBuffer);
        }
        this.bytesWritten = 0L;
    }

    public void closeArchive() throws IOException {
        this.closeEntry();
        this.paddingBuffer.clear();
        this.write(this.paddingBuffer);
        this.write(this.paddingBuffer);
    }
}

