/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.nio.ByteBuffer;
import uk.org.retep.util.cluster.ClusteredTime;
import uk.org.retep.util.io.tar.GnuHeader;
import uk.org.retep.util.io.tar.TarHeader;
import uk.org.retep.util.io.tar.TarHeaderType;

public abstract class StandardHeader {

    public static class Directory
    extends TarHeader.NamedHeader {
        public Directory(String name) {
            this(name, ClusteredTime.currentClusterTimeMillis());
        }

        public Directory(String name, long time) {
            super(name.endsWith("/") ? name : name + "/");
            this.mode = 16877;
            this.mtime = time / 1000L;
        }

        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.DIRECTORY;
        }
    }

    public static class ARegularFile
    extends TarHeader.FileHeader {
        public ARegularFile(String name) {
            super(name);
            if (name.length() > 100) {
                this.setPrevHeader(new GnuHeader.LongNameFile(name));
            }
        }

        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.AREGULAR_FILE;
        }
    }

    public static class RegularFile
    extends TarHeader.FileHeader {
        public RegularFile(String name) {
            super(name);
            if (name.length() > 100) {
                this.setPrevHeader(new GnuHeader.LongNameFile(name));
            }
        }

        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.REGULAR_FILE;
        }
    }

    public static class EndOfArchive
    extends TarHeader {
        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.AREGULAR_FILE;
        }

        @Override
        public void put(ByteBuffer buffer) {
            int l = Math.min(1024, buffer.remaining());
            for (int i = 0; i < l; ++i) {
                buffer.put((byte)0);
            }
        }

        @Override
        public int getTarHeaderSize() {
            return 1024;
        }
    }
}

