/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.nio.ByteBuffer;
import uk.org.retep.util.io.tar.TarHeader;
import uk.org.retep.util.io.tar.TarHeaderType;
import uk.org.retep.util.string.StringUtils;

public abstract class GnuHeader {

    public static class VolumeHeader
    extends TarHeader.NamedHeader {
        public VolumeHeader(String name) {
            super(name);
        }

        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.GNU_VOLUME_HEADER;
        }
    }

    public static class SparseFile
    extends TarHeader {
        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.GNU_SPARSE;
        }
    }

    public static class MultiVolume
    extends TarHeader {
        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.GNU_MULTIVOL;
        }
    }

    public static class LongNameFile
    extends TarHeader.NamedHeader {
        private String longName;

        public LongNameFile(String longName) {
            super("././@LongLink");
            this.longName = longName;
            this.size = longName.length() + 1;
        }

        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.GNU_LONGNAME;
        }

        @Override
        protected int getAdditionalSize() {
            return LongNameFile.getBlockSize((int)this.size);
        }

        @Override
        protected void putAdditional(ByteBuffer buffer) {
            StringUtils.putC(buffer, this.getAdditionalSize(), this.longName);
        }
    }

    public static class DumpDir
    extends TarHeader {
        @Override
        public TarHeaderType getTarHeaderType() {
            return TarHeaderType.GNU_DUMPDIR;
        }
    }
}

