/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.awt.EventQueue;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import uk.org.retep.annotations.DispatchThread;
import uk.org.retep.annotations.GlobalThread;
import uk.org.retep.annotations.InvocationType;
import uk.org.retep.annotations.WorkerThread;
import uk.org.retep.util.javac.JavacUtils;
import uk.org.retep.util.thread.ExecutorFactory;
import uk.org.retep.util.thread.IllegalThreadAccessException;

@SupportedAnnotationTypes(value={"uk.org.retep.annotations.DispatchThread", "uk.org.retep.annotations.GlobalThread", "uk.org.retep.annotations.WorkerThread"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ExecutorFactoryProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        JavacUtils utils = new JavacUtils(this.processingEnv, env);
        boolean claimed = this.process(DispatchThread.class, utils);
        claimed |= this.process(GlobalThread.class, utils);
        return claimed |= this.process(WorkerThread.class, utils);
    }

    private boolean process(Class<? extends Annotation> annotation, JavacUtils utils) {
        Set<? extends Element> annoElements = utils.env.getElementsAnnotatedWith(annotation);
        for (Element element : annoElements) {
            this.processAnnotation(utils, element, element.getAnnotation(annotation));
        }
        return !annoElements.isEmpty();
    }

    private void processAnnotation(JavacUtils utils, Element e, Annotation p) {
        ExecutableElement type = JavacUtils.findEnclosingExecutableElement(e);
        if (type == null) {
            utils.messager.printMessage(Diagnostic.Kind.ERROR, "Only methods can be annotated with @" + p.annotationType().getName(), e);
            return;
        }
        JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)JCTree.JCMethodDecl.class.cast(utils.trees.getTree(type));
        int pos = md.pos;
        Element cde = type.getEnclosingElement();
        JCTree.JCClassDecl cd = (JCTree.JCClassDecl)JCTree.JCClassDecl.class.cast(utils.trees.getTree(cde));
        boolean fail = false;
        for (JCTree.JCVariableDecl param : md.getParameters()) {
            if ((param.getModifiers().flags & 0x10L) != 0L) continue;
            utils.messager.printMessage(Diagnostic.Kind.ERROR, "Parameter " + param.getName() + " of method " + md.getName() + " must be declared final.", e);
            fail = true;
        }
        if (fail) {
            return;
        }
        if (md.getReturnType() instanceof JCTree.JCPrimitiveTypeTree && ((JCTree.JCPrimitiveTypeTree)JCTree.JCPrimitiveTypeTree.class.cast(md.getReturnType())).getPrimitiveTypeKind() == TypeKind.VOID) {
            this.createVoidProxy(e, p, md, pos, cd, utils);
        } else {
            utils.messager.printMessage(Diagnostic.Kind.ERROR, "Method " + md.getName() + " currently not supported.", e);
        }
    }

    private void createVoidProxy(Element e, Annotation p, JCTree.JCMethodDecl md, int pos, JCTree.JCClassDecl cd, JavacUtils utils) {
        long mdFlags = md.getModifiers().flags;
        JavacUtils.Idents idents = utils.getIdents(e);
        Name proxyMethodName = idents.nextMethId(md.getName());
        utils.createMethod(cd, pos, mdFlags & 8L | 2L, proxyMethodName, utils.voidType, (List<JCTree.JCVariableDecl>)md.getParameters(), (List<JCTree.JCExpression>)md.getThrows(), utils.make.Block(0L, (List<JCTree.JCStatement>)md.getBody().getStatements()));
        Generator generator = Generator.lookup(p.annotationType());
        JCTree.JCStatement statement = generator.generate(p, utils, idents, e, pos, md, cd, proxyMethodName);
        md.body = utils.block(pos, statement);
        md.body.pos = pos;
        md.getModifiers().flags = mdFlags;
    }

    static JCTree.JCStatement createLocalProxyCall(JavacUtils utils, Element e, int pos, JCTree.JCMethodDecl md, Name proxyMethodName) {
        JCTree.JCMethodInvocation mit = utils.call(e, pos, proxyMethodName, utils.voidType, utils.methodArguments(md));
        JCTree.JCExpressionStatement exec = utils.make.Exec(mit);
        exec.pos = pos;
        return (JCTree.JCStatement)JCTree.JCStatement.class.cast(exec);
    }

    static JCTree.JCExpression createRunnable(JavacUtils utils, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name className, Name proxyMethodName) {
        JCTree.JCExpression runnableIdent = utils.qualIdentAndLoad(Runnable.class);
        Symbol.ClassSymbol runSymb = new Symbol.ClassSymbol(8L, className, cd.sym);
        Symbol.VarSymbol thisSymb = new Symbol.VarSymbol(0L, utils.names._this, utils.syms.classType, runSymb);
        ListBuffer<JCTree> runBody = new ListBuffer<JCTree>();
        ListBuffer<JCTree.JCStatement> conStatements = new ListBuffer<JCTree.JCStatement>();
        ListBuffer<JCTree.JCVariableDecl> callParams = new ListBuffer<JCTree.JCVariableDecl>();
        ListBuffer<JCTree.JCVariableDecl> conParams = new ListBuffer<JCTree.JCVariableDecl>();
        long modc = 16L;
        JCTree.JCModifiers modcs = utils.make.Modifiers(16L);
        long modf = 18L;
        JCTree.JCModifiers modfs = utils.make.Modifiers(18L);
        int x = 1;
        for (JCTree.JCVariableDecl var : md.getParameters()) {
            JCTree.JCVariableDecl field = utils.make.VarDef(modfs, var.getName(), var.vartype, null);
            field.sym = new Symbol.VarSymbol(18L, var.getName(), var.type, thisSymb);
            runBody.append(field);
            callParams.append(field);
            Name vdn = utils.names.fromString("x" + x++);
            conParams.append(utils.make.VarDef(modcs, vdn, var.vartype, null));
            JCTree.JCIdent vi = utils.make.Ident(vdn);
            JCTree.JCExpression vdi = utils.make.QualIdent(new Symbol.VarSymbol(18L, var.getName(), var.type, thisSymb));
            conStatements.append(utils.make.Exec(utils.make.Assign(vdi, vi).setType(var.type)));
        }
        runBody.append(utils.createMethod(pos, 0x20000000L, utils.names.init, null, conParams.toList(), List.<JCTree.JCExpression>nil(), utils.block(pos, conStatements)));
        JCTree.JCMethodInvocation runmi = utils.call(e, pos, proxyMethodName, utils.voidType, utils.make.Idents(callParams.toList()));
        JCTree.JCStatement runst = (JCTree.JCStatement)JCTree.JCStatement.class.cast(utils.make.Exec(runmi));
        runBody.append(utils.createMethod(pos, 1L, utils.fromString("run"), utils.voidType, List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), utils.block(pos, runst)));
        JCTree.JCClassDecl runcd = utils.make.ClassDef(utils.make.Modifiers(md.mods.flags & 8L), className, List.nil(), null, List.of(runnableIdent), runBody.toList());
        runcd.sym = runSymb;
        cd.defs = cd.defs.prepend(runcd);
        JCTree.JCNewClass newrun = utils.make.NewClass(null, null, utils.make.Ident(className), utils.methodArguments(md), null);
        newrun.setType(runnableIdent.type);
        newrun.setPos(pos);
        return newrun;
    }

    private static enum Generator {
        GlobalThreadGenerator(GlobalThread.class){

            @Override
            public InvocationType getInvocationType(Annotation p) {
                return ((GlobalThread)GlobalThread.class.cast(p)).invocationType();
            }

            @Override
            public JCTree.JCStatement generate(Annotation p, JavacUtils utils, JavacUtils.Idents idents, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name proxyMethodName) {
                return this.generate(p, utils, idents, e, pos, md, cd, proxyMethodName, ExecutorFactory.class, "isGlobalThread", "globalInvokeLater");
            }
        }
        ,
        WorkerThreadGenerator(WorkerThread.class){

            @Override
            public InvocationType getInvocationType(Annotation p) {
                return ((WorkerThread)WorkerThread.class.cast(p)).invocationType();
            }

            @Override
            public JCTree.JCStatement generate(Annotation p, JavacUtils utils, JavacUtils.Idents idents, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name proxyMethodName) {
                return this.generate(p, utils, idents, e, pos, md, cd, proxyMethodName, ExecutorFactory.class, "isWorkerThread", "workerInvokeLater");
            }
        }
        ,
        DispatchThreadGenerator(DispatchThread.class){

            @Override
            public InvocationType getInvocationType(Annotation p) {
                return ((DispatchThread)DispatchThread.class.cast(p)).invocationType();
            }

            @Override
            public JCTree.JCStatement generate(Annotation p, JavacUtils utils, JavacUtils.Idents idents, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name proxyMethodName) {
                return this.generate(p, utils, idents, e, pos, md, cd, proxyMethodName, EventQueue.class, "isDispatchThread", "invokeLater");
            }
        };

        private Class<? extends Annotation> clazz;

        private Generator(Class<? extends Annotation> clazz) {
            this.clazz = clazz;
        }

        protected JCTree.JCStatement generate(Annotation p, JavacUtils utils, JavacUtils.Idents idents, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name proxyMethodName, Class factoryClass, String isMethod, String invokeLaterMethod) {
            JCTree.JCExpression executorFactoryIdent = utils.qualIdentAndLoad(factoryClass.getName());
            InvocationType it = this.getInvocationType(p);
            switch (it) {
                case INVOKE_IMMEDIATE: {
                    JCTree.JCIf ifs = utils.make.If(this.isThread(p, pos, utils, e, cd, executorFactoryIdent, isMethod), ExecutorFactoryProcessor.createLocalProxyCall(utils, e, pos, md, proxyMethodName), this.invokeLater(p, utils, idents, e, pos, md, cd, proxyMethodName, executorFactoryIdent, isMethod, invokeLaterMethod));
                    ifs.pos = pos;
                    return (JCTree.JCStatement)JCTree.JCStatement.class.cast(ifs);
                }
                case INVOKE_LATER: {
                    return this.invokeLater(p, utils, idents, e, pos, md, cd, proxyMethodName, executorFactoryIdent, isMethod, invokeLaterMethod);
                }
                case THREAD_ONLY: {
                    JCTree.JCIf ift = utils.make.If(this.isThread(p, pos, utils, e, cd, executorFactoryIdent, isMethod), ExecutorFactoryProcessor.createLocalProxyCall(utils, e, pos, md, proxyMethodName), this.throwException(utils, pos));
                    ift.pos = pos;
                    return (JCTree.JCStatement)JCTree.JCStatement.class.cast(ift);
                }
            }
            utils.messager.printMessage(Diagnostic.Kind.ERROR, "Unsupported InvocationType: " + (Object)((Object)it) + " in " + JavacUtils.findEnclosingTypeElement(e) + "." + JavacUtils.findEnclosingExecutableElement(e));
            return null;
        }

        protected JCTree.JCMethodInvocation isThread(Annotation p, int pos, JavacUtils utils, Element e, JCTree.JCClassDecl cd, JCTree.JCExpression executorFactoryIdent, String isMethod) {
            return utils.makeCall(e, cd.pos(), pos, executorFactoryIdent, utils.fromString(isMethod), List.<JCTree.JCExpression>nil());
        }

        protected JCTree.JCStatement invokeLater(Annotation p, JavacUtils utils, JavacUtils.Idents idents, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name proxyMethodName, JCTree.JCExpression executorFactoryIdent, String isMethod, String invokeLaterMethod) {
            Name className = idents.nextClassId();
            JCTree.JCExpression newrun = ExecutorFactoryProcessor.createRunnable(utils, e, pos, md, cd, className, proxyMethodName);
            JCTree.JCMethodInvocation il8r = utils.makeCall(e, newrun.pos(), pos, executorFactoryIdent, utils.fromString(invokeLaterMethod), this.invokeLater(p, newrun));
            return (JCTree.JCStatement)JCTree.JCStatement.class.cast(utils.make.Exec(il8r));
        }

        protected JCTree.JCStatement throwException(JavacUtils utils, int pos) {
            JCTree.JCExpression exceptionIdent = utils.qualIdentAndLoad(IllegalThreadAccessException.class);
            JCTree.JCNewClass newRun = utils.make.NewClass(null, null, exceptionIdent, List.<JCTree.JCExpression>nil(), null);
            newRun.setType(exceptionIdent.type);
            newRun.setPos(pos);
            JCTree.JCThrow ret = utils.make.Throw(newRun);
            ret.setPos(pos);
            return (JCTree.JCStatement)JCTree.JCStatement.class.cast(ret);
        }

        protected List<JCTree.JCExpression> invokeLater(Annotation p, JCTree.JCExpression newrun) {
            return List.of(newrun);
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.clazz;
        }

        public static Generator lookup(Class<? extends Annotation> clazz) {
            for (Generator gen : Generator.values()) {
                if (!clazz.equals(gen.getAnnotationClass())) continue;
                return gen;
            }
            throw new IllegalStateException("Unsupported Annotation " + clazz);
        }

        public JCTree.JCStatement generate(Annotation p, JavacUtils utils, JavacUtils.Idents idents, Element e, int pos, JCTree.JCMethodDecl md, JCTree.JCClassDecl cd, Name proxyMethodName) {
            throw new UnsupportedOperationException();
        }

        public InvocationType getInvocationType(Annotation p) {
            throw new UnsupportedOperationException();
        }
    }
}

