/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.concurrent.ConcurrencySupport;

@ThreadSafe
public class ListComboModel<T>
extends ConcurrencySupport
implements ComboBoxModel,
ListDataListener {
    private static final long serialVersionUID = 1239299388624023539L;
    private Object selected;
    protected List<T> list;
    protected Set<ListDataListener> listeners = new HashSet<ListDataListener>();
    private ListDataListener[] listenersCache = new ListDataListener[0];

    public ListComboModel() {
        this((List)null);
    }

    public ListComboModel(T ... list) {
        this.setData(list);
    }

    public ListComboModel(List<T> list) {
        this.setData(list);
    }

    public void setData(T ... list) {
        this.setData(Arrays.asList(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(List<T> list) {
        int oldSize = 0;
        int newSize = 0;
        this.writeLock().lock();
        try {
            oldSize = this.list == null ? 0 : this.list.size();
            this.list = list == null ? new ArrayList() : list;
            newSize = this.list.size();
        }
        finally {
            this.writeLock().unlock();
        }
        if (oldSize > newSize) {
            this.intervalRemoved(new ListDataEvent(this, 2, newSize, oldSize - 1));
        } else if (oldSize < newSize) {
            this.intervalAdded(new ListDataEvent(this, 1, oldSize, newSize - 1));
        }
        if (newSize > 0) {
            this.contentsChanged(new ListDataEvent(this, 0, 0, Math.min(oldSize, newSize) - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.readLock().lock();
        try {
            int n = this.list == null ? 0 : this.list.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int index) {
        this.readLock().lock();
        try {
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        this.readLock().lock();
        try {
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListDataListener(ListDataListener l) {
        this.writeLock().lock();
        try {
            this.listeners.add(l);
            this.listenersCache = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListDataListener(ListDataListener l) {
        this.writeLock().lock();
        try {
            this.listeners.remove(l);
            this.listenersCache = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListDataListener[] getListeners() {
        this.readLock().lock();
        try {
            ListDataListener[] listDataListenerArray = this.listenersCache;
            return listDataListenerArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public void contentsChanged(final ListDataEvent e) {
        final ListDataListener[] listeners = this.getListeners();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ListDataListener l : listeners) {
                    l.contentsChanged(e);
                }
            }
        });
    }

    @Override
    public void intervalAdded(final ListDataEvent e) {
        final ListDataListener[] listeners = this.getListeners();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ListDataListener l : listeners) {
                    l.intervalAdded(e);
                }
            }
        });
    }

    @Override
    public void intervalRemoved(final ListDataEvent e) {
        final ListDataListener[] listeners = this.getListeners();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ListDataListener l : listeners) {
                    l.intervalRemoved(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedItem(Object anItem) {
        this.writeLock().lock();
        try {
            this.selected = anItem;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSelectedItem() {
        this.readLock().lock();
        try {
            Object object = this.selected;
            return object;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(T element) {
        this.readLock().lock();
        try {
            int n = this.list.indexOf(element);
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(int index) {
        this.readLock().lock();
        try {
            if (index >= 0 && index < this.list.size()) {
                this.contentsChanged(new ListDataEvent(this, 0, index, index));
            }
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(T element) {
        this.readLock().lock();
        try {
            int index = this.list.indexOf(element);
            if (index >= 0 && index < this.list.size()) {
                this.contentsChanged(new ListDataEvent(this, 0, index, index));
            }
        }
        finally {
            this.readLock().unlock();
        }
    }
}

