/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import uk.org.retep.swing.model.ListComboModel;

public class ModifiableListComboModel<T>
extends ListComboModel<T>
implements MutableComboBoxModel {
    private int maxSize = 0;

    public ModifiableListComboModel() {
        this(new ArrayList(), 0);
    }

    public ModifiableListComboModel(List<T> list) {
        this(list, 0);
    }

    public ModifiableListComboModel(List<T> list, int maxSize) {
        super(list);
        this.maxSize = maxSize;
    }

    public ModifiableListComboModel(int maxSize) {
        this(new ArrayList(), maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSize() {
        this.readLock().lock();
        try {
            int n = this.maxSize;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        this.writeLock().lock();
        try {
            this.maxSize = Math.max(0, maxSize);
            if (maxSize > 0) {
                int firstSafeIndex = this.list.size() - maxSize;
                while (this.list.size() > maxSize) {
                    this.list.remove(0);
                }
                this.intervalRemoved(new ListDataEvent(this, 2, 0, firstSafeIndex - 1));
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock().lock();
        try {
            if (this.list != null) {
                int size = this.list.size();
                this.list.clear();
                this.intervalRemoved(new ListDataEvent(this, 2, 0, size));
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T v) {
        this.writeLock().lock();
        try {
            boolean ret = this.list.add(v);
            if (ret) {
                int index = this.list.indexOf(v);
                this.intervalAdded(new ListDataEvent(this, 1, index, index));
                if (this.maxSize > 0 && this.list.size() >= this.maxSize) {
                    this.remove(0);
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, T v) {
        this.writeLock().lock();
        try {
            this.list.add(index, v);
            this.intervalAdded(new ListDataEvent(this, 1, index, index));
            if (this.maxSize > 0 && this.list.size() >= this.maxSize) {
                this.remove(0);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public boolean addAll(Collection<? extends T> c) {
        boolean ret = false;
        for (T v : c) {
            ret |= this.add(v);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object v) {
        this.writeLock().lock();
        try {
            int index = this.list.indexOf(v);
            boolean ret = this.list.remove(v);
            if (ret) {
                this.intervalRemoved(new ListDataEvent(this, 2, index, index));
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        this.writeLock().lock();
        try {
            Object o = this.list.remove(index);
            this.intervalRemoved(new ListDataEvent(this, 2, index, index));
            Object e = o;
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public void addElement(Object obj) {
        this.add(obj);
    }

    @Override
    public void removeElement(Object obj) {
        this.remove(obj);
    }

    public void insertElementAt(Object obj, int index) {
        this.add(index, obj);
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }
}

