/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.monitor;

import javax.swing.JProgressBar;
import uk.org.retep.annotations.DispatchThread;
import uk.org.retep.annotations.InvocationType;
import uk.org.retep.util.monitor.ProgressListener;

public class JProgressBarListener
implements ProgressListener {
    private final JProgressBar component;
    private final JProgressBar secondaryComponent;

    public JProgressBarListener(JProgressBar component) {
        this(component, null);
    }

    public JProgressBarListener(JProgressBar component, JProgressBar secondaryComponent) {
        if (component == null && secondaryComponent == null) {
            throw new IllegalArgumentException("Both components may not be null");
        }
        this.component = component;
        this.secondaryComponent = secondaryComponent;
        if (component != null) {
            component.setIndeterminate(true);
        }
        if (secondaryComponent != null) {
            secondaryComponent.setIndeterminate(true);
        }
    }

    public JProgressBar getComponent() {
        return this.component;
    }

    public JProgressBar getSecondaryComponent() {
        return this.secondaryComponent;
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_LATER)
    public void showProgress(int progress) {
        if (this.component != null) {
            this.component.setValue(progress);
            this.component.setIndeterminate(false);
            this.component.repaint();
        }
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_LATER)
    public void showProgress(long inputSize, long outputSize) {
        if (this.component != null) {
            this.component.setValue((int)inputSize);
            this.component.setIndeterminate(false);
            this.component.repaint();
        }
        if (this.secondaryComponent != null) {
            this.secondaryComponent.setValue((int)outputSize);
            this.secondaryComponent.setIndeterminate(false);
            this.secondaryComponent.repaint();
        }
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_AND_WAIT)
    public void setMaximum(long maximum) {
        this.component.setMaximum((int)maximum);
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_AND_WAIT)
    public void setMaximum(long inputMaximum, long outputMaximum) {
        if (this.component != null) {
            this.component.setMaximum((int)inputMaximum);
        }
        if (this.secondaryComponent != null) {
            this.secondaryComponent.setMaximum((int)outputMaximum);
        }
    }
}

