/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.org.retep.util.monitor.ProgressListener;
import uk.org.retep.util.monitor.ProgressListenerAdaptor;

public class BandwidthProgressListener
extends ProgressListenerAdaptor {
    public static final String COLUMN_NAMES = "   Time    Bandwidth     Output    ";
    public static final String SEPARATOR = "----------------------------------";
    public static final String FORMAT = " %6.2f s %6d KB/s %8.1f KB ";
    private long start;
    private long latest;
    private long inputSize;
    private long outputSize;

    @Override
    public void showProgress(long inputSize, long outputSize) {
        this.latest = System.currentTimeMillis();
        if (this.start == 0L) {
            this.start = this.latest;
        }
        this.inputSize = inputSize;
        this.outputSize = outputSize;
    }

    public void reset() {
        this.outputSize = 0L;
        this.inputSize = 0L;
        this.latest = 0L;
        this.start = 0L;
    }

    public long getLatest() {
        return this.latest;
    }

    public long getInputSize() {
        return this.inputSize;
    }

    public long getOutputSize() {
        return this.outputSize;
    }

    public long getStart() {
        return this.start;
    }

    public long getDuration() {
        return this.latest - this.start;
    }

    public long getDurationSeconds() {
        return this.getDuration() / 1000L;
    }

    public static long getKBs(long size, long millis) {
        return (size >> 10) * 1000L / millis;
    }

    public long getInputKBs() {
        return BandwidthProgressListener.getKBs(this.inputSize, this.getDuration());
    }

    public long getOutputKBs() {
        return BandwidthProgressListener.getKBs(this.outputSize, this.getDuration());
    }

    public String toString() {
        return String.format(FORMAT, (double)this.getDuration() / 1000.0, this.getInputKBs(), (double)this.getInputSize() / 1024.0);
    }

    public static class MonitoredOutputStream
    extends OutputStream {
        private long size;
        private final ProgressListener listener;
        private final OutputStream stream;

        public MonitoredOutputStream(OutputStream stream, ProgressListener listener) {
            this.stream = stream;
            this.listener = listener;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
            if (this.listener != null) {
                this.listener.showProgress(this.size, this.size);
            }
            if (this.stream != null) {
                this.stream.write(b);
            }
        }
    }

    public static class MonitoredInputStream
    extends InputStream {
        private long size;
        private final ProgressListener listener;
        private final InputStream stream;

        public MonitoredInputStream(InputStream stream, ProgressListener listener) {
            this.stream = stream;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            try {
                int n = this.stream.read();
                return n;
            }
            finally {
                ++this.size;
                if (this.listener != null) {
                    this.listener.showProgress(this.size, this.size);
                }
            }
        }
    }
}

