/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public final class DOMUtils {
    private static DOMImplementationLS domImplLs;
    private static DocumentBuilder docBuilder;

    private DOMUtils() {
    }

    public static Element getElement(Node node) {
        return (Element)node;
    }

    public static Element getElement(Node node, String name) {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            return DOMUtils.getElement(node);
        }
        return null;
    }

    public static String getAttribute(Node node, String name) {
        return DOMUtils.getAttribute(DOMUtils.getElement(node), name);
    }

    public static String getAttribute(Element element, String name) {
        Attr attr = element.getAttributeNode(name);
        return attr == null ? null : attr.getValue();
    }

    public static Attr getAttribute(Node node) {
        return (Attr)node;
    }

    public static String lookupNamespace(Map<String, String> nsMap, Node n) {
        if (nsMap == null) {
            return null;
        }
        String uri = n.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return n.getNamespaceURI();
        }
        return nsMap.get(uri);
    }

    public static void writeNSPrefix(Map<String, String> nsMap, Node n, Writer w) throws IOException {
        if (nsMap == null) {
            return;
        }
        String ns = DOMUtils.lookupNamespace(nsMap, n);
        if (ns != null) {
            w.write(ns);
            w.write(58);
        }
    }

    public static void write(Element e, Writer w) throws IOException {
        DOMUtils.write(null, e, w);
    }

    public static void write(Map<String, String> nsMap, Element e, Writer w) throws IOException {
        Node child;
        w.write(60);
        DOMUtils.writeNSPrefix(nsMap, e, w);
        w.write(e.getNodeName());
        NamedNodeMap attrs = e.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                w.write(32);
                DOMUtils.writeNSPrefix(nsMap, attr, w);
                w.write(attr.getName());
                w.write("=\"");
                w.write(attr.getValue());
                w.write(34);
            }
        }
        if ((child = e.getFirstChild()) == null) {
            w.write("/>");
        } else {
            w.write(62);
            while (child != null) {
                if (child instanceof Element) {
                    DOMUtils.write(nsMap, (Element)child, w);
                } else {
                    w.write(child.getTextContent());
                }
                child = child.getNextSibling();
            }
            w.write("</");
            w.write(e.getNodeName());
            w.write(62);
        }
    }

    public static String toString(Element e) throws IOException {
        return DOMUtils.toString(null, e);
    }

    public static String toString(Map<String, String> nsMap, Element e) throws IOException {
        StringWriter w = new StringWriter();
        DOMUtils.write(nsMap, e, w);
        return w.toString();
    }

    public static Document newDocument() throws ParserConfigurationException {
        if (docBuilder == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docFactory.newDocumentBuilder();
        }
        return docBuilder.newDocument();
    }

    public static DocumentFragment newDocumentFragment() throws ParserConfigurationException {
        if (docBuilder == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docFactory.newDocumentBuilder();
        }
        return docBuilder.newDocument().createDocumentFragment();
    }

    private static void init() {
        try {
            if (domImplLs != null) {
                return;
            }
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementation impl = reg.getDOMImplementation("XML 3.0");
            domImplLs = (DOMImplementationLS)DOMImplementationLS.class.cast(impl.getFeature("LS", "3.0"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String parseNodeLS(Node node) {
        DOMUtils.init();
        StringWriter writer = new StringWriter();
        LSOutput output = domImplLs.createLSOutput();
        output.setCharacterStream(writer);
        LSSerializer serializer = domImplLs.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        serializer.write(node, output);
        return writer.toString();
    }

    public static final Document parseXmlLS(String xml) {
        DOMUtils.init();
        LSInput in = domImplLs.createLSInput();
        in.setStringData(xml);
        LSParser parser = domImplLs.createLSParser((short)1, null);
        return parser.parse(in);
    }

    public static String parseNodeTransformer(Node node) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setAttribute("indent-number", 4);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Transformer tr = tf.newTransformer();
        tr.setOutputProperty("omit-xml-declaration", "yes");
        tr.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        tr.transform(new DOMSource(node), result);
        return sw.toString();
    }
}

