/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class ListLogAppender
extends AppenderSkeleton
implements ListModel {
    private static final int MAX_ROWS = 500;
    private static Map<String, ListLogAppender> appenders = Collections.synchronizedMap(new HashMap());
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<String> list = new ArrayList<String>();
    private Set<ListDataListener> listeners;
    private ListDataListener[] listenerCache;
    private int maxRows = 500;

    public static ListLogAppender getCollection(String name) {
        return appenders.get(name);
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = Math.min(100, maxRows);
    }

    public void setName(String name) {
        super.setName(name);
        appenders.put(name, this);
    }

    protected synchronized void append(LoggingEvent event) {
        this.append(this.layout.format(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(String s) {
        this.lock.writeLock().lock();
        try {
            int first = this.list.size() - 1;
            int l = s.length();
            int p = 0;
            int e = s.indexOf(10);
            while (e > p && p < l) {
                this.list.add(s.substring(p, e));
                p = e + 1;
                e = s.indexOf(10, p);
                if (first <= 0) continue;
                --first;
            }
            if (p < l) {
                this.list.add(s.substring(p));
            }
            if (this.list.size() > this.maxRows) {
                int d = this.list.size() - this.maxRows;
                while (this.list.size() > this.maxRows) {
                    this.list.remove(0);
                }
                this.fireRemove(d);
            }
            this.fireAdd(first, this.list.size());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void fireAdd(int s, int e) {
        this.fire(new ListDataEvent(this, 1, s, e));
    }

    private void fireRemove(int i) {
        this.fire(new ListDataEvent(this, 2, 0, i));
    }

    private void fire(final ListDataEvent e) {
        final ListDataListener[] listeners = this.getListeners();
        if (listeners != null && listeners.length > 0) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (ListDataListener l : listeners) {
                            l.intervalAdded(e);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.list.clear();
    }

    public boolean requiresLayout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.lock.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementAt(int index) {
        this.lock.readLock().lock();
        try {
            String string = this.list.get(index);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListDataListener(ListDataListener l) {
        this.lock.writeLock().lock();
        try {
            if (this.listeners == null) {
                this.listeners = new HashSet<ListDataListener>();
            }
            this.listeners.add(l);
            this.updateCache();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListDataListener(ListDataListener l) {
        this.lock.writeLock().lock();
        try {
            this.listeners.remove(l);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateCache() {
        this.listenerCache = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListDataListener[] getListeners() {
        this.lock.readLock().lock();
        try {
            ListDataListener[] listDataListenerArray = this.listenerCache;
            return listDataListenerArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

