/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import uk.org.retep.util.collections.ConcurrencySupport;
import uk.org.retep.util.collections.queue.BoundedLinkedList;

public class JAXBUtil
extends ConcurrencySupport {
    private final Set<String> packages = new HashSet<String>();
    private JAXBContext context;
    private MarshallerCallback marshallerCallback;
    private UnmarshallerCallback unmarshallerCallback;
    private Queue<Unmarshaller> unmarshallerQueue;
    private Queue<Marshaller> marshallerQueue = new LinkedList<Marshaller>();
    private int poolSize = 0;
    private ClassLoader classLoader;

    public JAXBUtil() {
        this.unmarshallerQueue = new LinkedList<Unmarshaller>();
    }

    public JAXBUtil(String ... packages) {
        this();
        for (String pkg : packages) {
            this.addPackage(pkg);
        }
    }

    public JAXBUtil(ArrayList<String> packages) {
        this();
        for (String pkg : packages) {
            this.addPackage(pkg);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(String ... pkg) {
        this.writeLock().lock();
        try {
            for (String p : pkg) {
                this.packages.add(p);
            }
        }
        finally {
            this.context = null;
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(String pkg) {
        this.writeLock().lock();
        try {
            if (pkg.contains(":")) {
                for (String p : pkg.split(":")) {
                    this.packages.add(p);
                }
            } else {
                this.packages.add(pkg);
            }
        }
        finally {
            this.context = null;
            this.writeLock().unlock();
        }
    }

    public void addPackage(Package ... packages) {
        for (Package pkg : packages) {
            this.addPackage(pkg.getName());
        }
    }

    public void addPackage(Class<?> clazz) {
        this.addPackage(clazz.getPackage());
    }

    public void addPackages(Class<?> clazz) {
        this.addPackages(clazz.getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackages(Package pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package may not be null");
        }
        this.writeLock().lock();
        try {
            String name = pkg.getName();
            for (Package p : Package.getPackages()) {
                if (!p.getName().startsWith(name)) continue;
                this.packages.add(p.getName());
            }
        }
        finally {
            this.context = null;
            this.writeLock().unlock();
        }
    }

    public void addSubPackages(String name) {
        this.addPackages(JAXBUtil.findPackage(name));
    }

    private static Package findPackage(String name) {
        Package pkg = Package.getPackage(name);
        while (name.length() > 0 && pkg == null) {
            int i = name.lastIndexOf(46);
            if ((name = i > -1 ? name.substring(0, i) : "").length() <= 0) continue;
            pkg = Package.getPackage(name);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(String ... pkg) {
        this.writeLock().lock();
        try {
            for (String p : pkg) {
                this.packages.remove(p);
            }
        }
        finally {
            this.context = null;
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(String pkg) {
        this.writeLock().lock();
        try {
            if (pkg.contains(":")) {
                for (String p : pkg.split(":")) {
                    this.packages.remove(p);
                }
            } else {
                this.packages.remove(pkg);
            }
        }
        finally {
            this.context = null;
            this.writeLock().unlock();
        }
    }

    public void removePackage(Package pkg) {
        this.removePackage(pkg.getName());
    }

    public void removePackage(Class<?> clazz) {
        this.removePackage(clazz.getPackage());
    }

    public void removePackages(Class<?> clazz) {
        this.removeSubPackages(clazz.getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubPackages(Package pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package may not be null");
        }
        this.writeLock().lock();
        try {
            String name = pkg.getName();
            for (Package p : Package.getPackages()) {
                if (!p.getName().startsWith(name)) continue;
                this.packages.remove(p.getName());
            }
        }
        finally {
            this.context = null;
            this.writeLock().unlock();
        }
    }

    public void removePackages(String name) {
        this.removeSubPackages(JAXBUtil.findPackage(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJAXBContext() throws JAXBException {
        this.writeLock().lock();
        try {
            if (this.context == null) {
                this.getLog().info("Creating JAXBContext");
                boolean notFirst = false;
                StringBuilder path = new StringBuilder();
                for (String pkg : this.packages) {
                    if (notFirst) {
                        path.append(':');
                    } else {
                        notFirst = true;
                    }
                    path.append(pkg);
                }
                this.context = this.classLoader == null ? JAXBContext.newInstance((String)path.toString()) : JAXBContext.newInstance((String)path.toString(), (ClassLoader)this.classLoader);
            }
            JAXBContext jAXBContext = this.context;
            return jAXBContext;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureMarshallerPoolSize(int size) throws JAXBException {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        int remaining = 0;
        do {
            this.release(this.createMarshaller());
            this.readLock().lock();
            try {
                remaining = this.poolSize == 0 ? size : Math.min(this.poolSize, size);
            }
            finally {
                this.readLock().unlock();
            }
        } while ((remaining -= this.marshallerQueue.size()) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureUnmarshallerPoolSize(int size) throws JAXBException {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        int remaining = 0;
        do {
            this.release(this.createUnmarshaller());
            this.readLock().lock();
            try {
                remaining = this.poolSize == 0 ? size : Math.min(this.poolSize, size);
            }
            finally {
                this.readLock().unlock();
            }
        } while ((remaining -= this.unmarshallerQueue.size()) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolSize(int poolSize) {
        this.writeLock().lock();
        try {
            if (this.poolSize == poolSize) {
                return;
            }
            LinkedList<Unmarshaller> newUnmarshallerQueue = null;
            LinkedList<Marshaller> newMarshallerQueue = null;
            if (poolSize < 1) {
                this.poolSize = 0;
                newUnmarshallerQueue = new LinkedList<Unmarshaller>();
                newMarshallerQueue = new LinkedList<Marshaller>();
            } else {
                this.poolSize = poolSize;
                newUnmarshallerQueue = new BoundedLinkedList(poolSize);
                newMarshallerQueue = new BoundedLinkedList(poolSize);
            }
            for (Unmarshaller unmarshaller : this.unmarshallerQueue) {
                newUnmarshallerQueue.offer(unmarshaller);
            }
            for (Marshaller marshaller : this.marshallerQueue) {
                newMarshallerQueue.offer(marshaller);
            }
            this.unmarshallerQueue = newUnmarshallerQueue;
            this.marshallerQueue = newMarshallerQueue;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = null;
        this.writeLock().lock();
        try {
            marshaller = this.marshallerQueue.poll();
        }
        finally {
            this.writeLock().unlock();
        }
        if (marshaller == null) {
            marshaller = this.createMarshaller();
        }
        return marshaller;
    }

    private Marshaller createMarshaller() throws JAXBException {
        this.getLog().info("Creating Marshaller");
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        if (this.marshallerCallback != null) {
            this.marshallerCallback.initialiseMarshaller(marshaller, this);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unmarshaller getUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = null;
        this.writeLock().lock();
        try {
            unmarshaller = this.unmarshallerQueue.poll();
        }
        finally {
            this.writeLock().unlock();
        }
        if (unmarshaller == null) {
            unmarshaller = this.createUnmarshaller();
        }
        return unmarshaller;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        this.getLog().info("Creating Unmarshaller");
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        if (this.unmarshallerCallback != null) {
            this.unmarshallerCallback.initialiseUnmarshaller(unmarshaller, this);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Marshaller marshaller) {
        this.writeLock().lock();
        try {
            boolean bl = this.marshallerQueue.offer(marshaller);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Unmarshaller unmarshaller) {
        this.writeLock().lock();
        try {
            boolean bl = this.unmarshallerQueue.offer(unmarshaller);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public static JAXBElement getJAXBElement(Object o) {
        return (JAXBElement)o;
    }

    public MarshallerCallback getMarshallerCallback() {
        return this.marshallerCallback;
    }

    public void setMarshallerCallback(MarshallerCallback marshallerCallback) {
        this.marshallerCallback = marshallerCallback;
    }

    public UnmarshallerCallback getUnmarshallerCallback() {
        return this.unmarshallerCallback;
    }

    public void setUnmarshallerCallback(UnmarshallerCallback unmarshallerCallback) {
        this.unmarshallerCallback = unmarshallerCallback;
    }

    public static interface UnmarshallerCallback {
        public void initialiseUnmarshaller(Unmarshaller var1, JAXBUtil var2) throws PropertyException;
    }

    public static interface MarshallerCallback {
        public void initialiseMarshaller(Marshaller var1, JAXBUtil var2) throws PropertyException;
    }
}

