/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import uk.org.retep.util.http.AbstractHttpHandler;
import uk.org.retep.util.http.RequestUtils;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.mime.ContentType;
import uk.org.retep.util.mime.ContentTypeFactory;
import uk.org.retep.util.string.StringUtils;

public class ResourceHandler
extends AbstractHttpHandler {
    private final String basePackage;

    public ResourceHandler(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public void processGet(HttpExchange exchange) throws IOException {
        String fullPath = exchange.getRequestURI().getPath();
        String path = fullPath.substring(exchange.getHttpContext().getPath().length());
        try {
            URL url = this.getClass().getResource(this.basePackage + path);
            this.sendFile(exchange, url);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            RequestUtils.sendResponse(exchange, 500, "%s is forbidden", path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(HttpExchange exchange, URL url) throws IOException {
        ContentType contentType = null;
        try {
            contentType = ContentTypeFactory.getContentTypeBySuffix(StringUtils.getFileSuffix(url.getPath()));
        }
        catch (IllegalArgumentException iae) {
            contentType = ContentType.TEXT_PLAIN;
        }
        RequestUtils.sendResponseHeaders(exchange, contentType);
        OutputStream os = exchange.getResponseBody();
        try {
            InputStream is = url.openStream();
            try {
                FileUtils.copy(is, os);
            }
            finally {
                is.close();
            }
        }
        finally {
            os.close();
        }
    }
}

