/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.set;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import uk.org.retep.util.collections.set.ConcurrentSet;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E>,
ConcurrentSet<E> {
    private static final Object PRESENT = new Object();
    private transient ConcurrentMap<E, Object> map;
    private ReentrantLock lock = new ReentrantLock();

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap<E, Object>();
    }

    public ConcurrentHashSet(Collection<? extends E> c) {
        this.map = new ConcurrentHashMap<E, Object>(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        this.map = new ConcurrentHashMap<E, Object>(initialCapacity, loadFactor);
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap<E, Object>(initialCapacity);
    }

    ConcurrentHashSet(ConcurrentHashMap<E, Object> map) {
        this.map = map;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean addIfAbsent(E e) {
        return this.map.putIfAbsent(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

