/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.callback;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import uk.org.retep.util.callback.Callback;

public class CallbackList<T, U>
implements ActionListener {
    private List<Callback<T, U>> list = new ArrayList<Callback<T, U>>();
    private int id = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Callback<T, U> cb) {
        List<Callback<T, U>> list = this.list;
        synchronized (list) {
            if (!this.list.contains(cb)) {
                this.list.add(cb);
                cb.setID(this.id++);
            }
            return cb.getID();
        }
    }

    public void remove(int id) {
        this.remove(this.getID(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Callback<T, U> cb) {
        if (cb == null) {
            return;
        }
        List<Callback<T, U>> list = this.list;
        synchronized (list) {
            while (this.list.contains(cb)) {
                this.list.remove(cb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Callback<T, U> getID(int id) {
        List<Callback<T, U>> list = this.list;
        synchronized (list) {
            for (Callback<T, U> cb : this.list) {
                if (cb.getID() != id) continue;
                return cb;
            }
        }
        return null;
    }

    public Callback<T, U> getIndex(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        Object[] args = null;
        for (Callback<T, U> cb : this.list) {
            if (!src.equals(cb.getObject())) continue;
            if (args == null) {
                args = new Object[1];
            }
            String cmd = cb.getUserData() != null ? cb.getUserData().toString() : e.getActionCommand();
            args[0] = new ActionEvent(e.getSource(), cb.getID(), cmd, e.getModifiers());
            try {
                cb.invoke(args);
            }
            catch (Exception ex) {}
        }
    }
}

