/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.retep.util.string.Sentence;
import uk.org.retep.util.string.StringUtils;

public class SentenceUtils {
    private static final String PATTERN_START = "\\s*(";
    private static final String PATTERN_END = ")\\s*";
    private Pattern sentencePattern;
    private Pattern wordPattern;
    private Set<AbstractSplitter> splitters = new LinkedHashSet<AbstractSplitter>();

    public SentenceUtils() {
    }

    public SentenceUtils(Collection<AbstractSplitter> splitters) {
        this();
        for (AbstractSplitter splitter : splitters) {
            this.addSplitter(splitter, false);
        }
        this.configurePatterns();
    }

    public boolean addWordSplitter(String pattern) {
        return this.addSplitter(new WordSplitter(pattern));
    }

    public boolean addSentenceSplitter(String pattern) {
        return this.addSplitter(new SentenceSplitter(pattern));
    }

    public boolean addSplitter(AbstractSplitter splitter) {
        return this.addSplitter(splitter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSplitter(AbstractSplitter splitter, boolean rebuild) {
        boolean added = false;
        Set<AbstractSplitter> set = this.splitters;
        synchronized (set) {
            added = this.splitters.add(splitter);
        }
        if (added && rebuild) {
            this.configurePatterns();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurePatterns() {
        StringBuilder sentenceSB = new StringBuilder(PATTERN_START);
        StringBuilder wordSB = new StringBuilder(PATTERN_START);
        Set<AbstractSplitter> set = this.splitters;
        synchronized (set) {
            block7: for (AbstractSplitter splitter : this.splitters) {
                switch (splitter.getType()) {
                    case SENTENCE: {
                        sentenceSB.append(splitter.getSplitterPattern()).append('|');
                        continue block7;
                    }
                    case WORD: {
                        wordSB.append(splitter.getSplitterPattern()).append('|');
                        continue block7;
                    }
                }
                throw new IllegalStateException("Invalid splitter type");
            }
        }
        if (sentenceSB.length() > PATTERN_START.length()) {
            sentenceSB.setLength(sentenceSB.length() - 1);
        }
        if (wordSB.length() > PATTERN_START.length()) {
            wordSB.setLength(wordSB.length() - 1);
        }
        sentenceSB.append(PATTERN_END);
        wordSB.append(PATTERN_END);
        this.sentencePattern = Pattern.compile(sentenceSB.toString());
        this.wordPattern = Pattern.compile(wordSB.toString());
    }

    public Sentence createSentence(String sentence) {
        if (!sentence.startsWith(" ")) {
            sentence = " " + sentence;
        }
        if (!sentence.endsWith(" ")) {
            sentence = sentence + " ";
        }
        return new Sentence(sentence, this.getMappings(sentence), this.normaliseString(sentence));
    }

    public Sentence[] normaliseSentence(String original) {
        String sentence;
        Matcher matcher = this.sentencePattern.matcher(original);
        LinkedList<Sentence> sentences = new LinkedList<Sentence>();
        int beginIndex = 0;
        while (matcher.find()) {
            int endIndex = matcher.start();
            String sentence2 = original.substring(beginIndex, endIndex);
            if (StringUtils.isStringNotEmpty(sentence2.trim())) {
                sentences.add(this.createSentence(sentence2));
            }
            beginIndex = endIndex + matcher.group().length();
        }
        if (beginIndex <= original.length() && StringUtils.isStringNotEmpty(sentence = original.substring(beginIndex).trim())) {
            sentence = " " + sentence + " ";
            sentences.add(new Sentence(sentence, this.getMappings(sentence), this.normaliseString(sentence)));
        }
        return sentences.toArray(new Sentence[sentences.size()]);
    }

    public String normaliseString(String sentence) {
        String word;
        Matcher matcher = this.wordPattern.matcher(sentence);
        LinkedList<String> words = new LinkedList<String>();
        int beginIndex = 0;
        while (matcher.find()) {
            int endIndex = matcher.start();
            String word2 = sentence.substring(beginIndex, endIndex).trim();
            if (StringUtils.isStringNotEmpty(word2)) {
                words.add(word2);
            }
            beginIndex = endIndex + matcher.group().length();
        }
        if (beginIndex <= sentence.length() && StringUtils.isStringNotEmpty((word = sentence.substring(beginIndex).trim()).trim())) {
            words.add(word);
        }
        return StringUtils.join(' ', words).toUpperCase();
    }

    public Integer[] getMappings(String input) {
        ArrayList<Integer> mappings = new ArrayList<Integer>(2);
        Matcher matcher = this.wordPattern.matcher(input);
        boolean beginIndex = false;
        while (matcher.find()) {
            mappings.add(matcher.start());
        }
        return mappings.toArray(new Integer[mappings.size()]);
    }

    public static class WordMapper {
        private int charIndex;
        private int listIndex;
        private int spaceCount;
        private final List<Integer> mappings = new LinkedList<Integer>();
        private String input;
        private String find;
        private String replace;

        public WordMapper(String input) {
            char[] chars = input.toCharArray();
            int n = chars.length;
            for (int i = 0; i < n; ++i) {
                if (chars[i] != ' ') continue;
                this.mappings.add(i);
            }
        }

        private int spaceCount(String string) {
            return this.spaceCount(string, 0, string.length());
        }

        private int spaceCount(String string, int beginIndex, int endIndex) {
            int spaces = 0;
            char[] chars = string.toCharArray();
            int n = endIndex;
            for (int i = beginIndex; i < n; ++i) {
                if (chars[i] != ' ') continue;
                ++spaces;
            }
            return spaces;
        }

        public void prepare(String input, String find, String replace) {
            this.input = input;
            this.find = find;
            this.replace = replace;
            this.spaceCount = this.spaceCount(find);
            this.listIndex = 0;
            this.charIndex = 0;
        }

        public void update(int beginIndex) {
            this.listIndex += this.spaceCount(this.input, this.charIndex, beginIndex);
            this.charIndex = beginIndex;
            int n = this.spaceCount;
            int m = this.replace.length();
            for (int j = 0; j < m; ++j) {
                if (this.replace.charAt(j) != ' ' || --n >= 0) continue;
                this.mappings.add(this.listIndex++, null);
            }
            while (n-- > 0) {
                this.mappings.remove(this.listIndex);
            }
        }

        public Integer[] toArray() {
            return this.mappings.toArray(new Integer[this.mappings.size()]);
        }
    }

    public class SentenceSplitter
    extends AbstractSplitter {
        public SentenceSplitter(String pattern) {
            super(pattern);
        }

        @Override
        public Type getType() {
            return Type.SENTENCE;
        }
    }

    public class WordSplitter
    extends AbstractSplitter {
        public WordSplitter(String pattern) {
            super(pattern);
        }

        @Override
        public Type getType() {
            return Type.WORD;
        }
    }

    public static abstract class AbstractSplitter {
        private String splitterPattern;

        public AbstractSplitter(String pattern) {
            this.splitterPattern = pattern;
        }

        public abstract Type getType();

        public final String getSplitterPattern() {
            return this.splitterPattern;
        }

        public final String toString() {
            return String.format("%s[%s]", new Object[]{this.getType(), this.getSplitterPattern()});
        }
    }

    public static enum Type {
        WORD,
        SENTENCE;

    }
}

