/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyExpansion {
    private static Pattern PATTERN = Pattern.compile("(\\$\\{([^\\}]*?)\\})");

    private PropertyExpansion() {
    }

    public static String expandMap(String source, Map<?, ?> map) {
        StringBuffer sb = new StringBuffer();
        Matcher match = PATTERN.matcher(source);
        while (match.find()) {
            String name = match.group(2);
            match.appendReplacement(sb, String.valueOf(map.get(name)));
        }
        match.appendTail(sb);
        return sb.toString();
    }

    private static <K, V> Map<K, String> newMap(Map<K, V> map) {
        if (map instanceof LinkedHashMap) {
            return new LinkedHashMap();
        }
        if (map instanceof ConcurrentHashMap) {
            return new ConcurrentHashMap();
        }
        return new HashMap();
    }

    public static <K, V> Map<K, String> expandMap(Map<K, V> source, Map<?, ?> map) {
        Map<K, String> newMap = PropertyExpansion.newMap(source);
        if (map == null) {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                newMap.put(entry.getKey(), entry.getValue().toString());
            }
        } else {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                newMap.put(entry.getKey(), PropertyExpansion.expandMap(entry.getValue().toString(), map));
            }
        }
        return newMap;
    }

    public static String expandSystemProperties(String source) {
        return PropertyExpansion.expandMap(source, System.getProperties());
    }

    public static <K, V> Map<K, String> expandSystemProperties(Map<K, V> source) {
        return PropertyExpansion.expandMap(source, System.getProperties());
    }

    public static String expandPreferences(String source, Preferences preferences) {
        StringBuffer sb = new StringBuffer();
        Matcher match = PATTERN.matcher(source);
        while (match.find()) {
            String name = match.group(2);
            match.appendReplacement(sb, preferences.get(name, "??" + name + "??"));
        }
        match.appendTail(sb);
        return sb.toString();
    }

    public static <K, V> Map<K, String> expandPreferences(Map<K, V> source, Preferences preferences) {
        Map<K, String> newMap = PropertyExpansion.newMap(source);
        for (Map.Entry<K, V> entry : source.entrySet()) {
            newMap.put(entry.getKey(), PropertyExpansion.expandPreferences(String.valueOf(entry.getValue()), preferences));
        }
        return newMap;
    }
}

