/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.string;

import uk.org.retep.util.string.StringUtils;

public class GlobMatcher {
    public static final String GLOB = "*";

    public static boolean matches(String glob, String src) {
        if (StringUtils.isStringEmpty(glob) || StringUtils.isStringEmpty(src)) {
            return false;
        }
        if (GLOB.equals(glob)) {
            return true;
        }
        if (glob.startsWith(GLOB)) {
            return src.endsWith(glob.substring(1));
        }
        if (glob.endsWith(GLOB)) {
            return src.startsWith(glob.substring(0, glob.length() - 1));
        }
        return glob.equals(src);
    }

    public static String extractMatch(String glob, String src) {
        if (StringUtils.isStringEmpty(glob) || StringUtils.isStringEmpty(src)) {
            return null;
        }
        if (GLOB.equals(glob)) {
            return src;
        }
        if (glob.startsWith(GLOB) && src.endsWith(glob.substring(1))) {
            return src.substring(0, src.length() - glob.length() + 1);
        }
        if (glob.endsWith(GLOB) && src.startsWith(glob.substring(0, glob.length() - 1))) {
            return src.substring(glob.length() - 1);
        }
        if (glob.equals(src)) {
            return src;
        }
        return null;
    }

    private GlobMatcher() {
    }
}

