/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.mime;

import java.util.HashMap;
import java.util.Map;
import uk.org.retep.util.mime.ContentType;

public final class ContentTypeFactory {
    private static Map<String, ContentType> suffixes = new HashMap<String, ContentType>();
    private static Map<String, ContentType> mimetype = new HashMap<String, ContentType>();

    private ContentTypeFactory() {
    }

    public static ContentType getContentTypeByMimeType(String mimeType) {
        ContentType contentType = mimetype.get(mimeType);
        if (contentType == null) {
            throw new IllegalArgumentException("Unsupported contentType: " + mimeType);
        }
        return contentType;
    }

    public static ContentType getContentTypeBySuffix(String suffix) {
        ContentType ct;
        String trueSuffix = suffix;
        int i = trueSuffix.lastIndexOf(46);
        if (i > -1) {
            trueSuffix = trueSuffix.substring(i + 1).toLowerCase();
        }
        if ((ct = suffixes.get(trueSuffix)) == null) {
            throw new IllegalArgumentException("Unsupported file type: " + suffix);
        }
        return ct;
    }

    public static void main(String ... args) {
        System.out.println("Mimetypes:");
        System.out.println("==========");
        for (Map.Entry<String, ContentType> e : mimetype.entrySet()) {
            System.out.printf("%30s %s\n", new Object[]{e.getKey(), e.getValue()});
        }
        System.out.println();
        System.out.println("File types:");
        System.out.println("===========");
        for (Map.Entry<String, ContentType> e : suffixes.entrySet()) {
            System.out.printf("%8s %s\n", new Object[]{e.getKey(), e.getValue()});
        }
    }

    static {
        for (ContentType ct : ContentType.values()) {
            for (String s : ct.getSuffices()) {
                if (suffixes.containsKey(s)) {
                    System.err.printf("ContentTypeFactory already has suffix %s defined: existing=%s new=%s\n", new Object[]{s, suffixes.get(s), ct});
                    continue;
                }
                suffixes.put(s, ct);
            }
            if (mimetype.containsKey(ct.getMimeType())) {
                System.err.printf("ContentTypeFactory already has mimttype %s defined: existing=%s new=%s\n", new Object[]{ct.getMimeType(), mimetype.get(ct.getMimeType()), ct});
                continue;
            }
            mimetype.put(ct.getMimeType(), ct);
        }
    }
}

