/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.javac;

import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class JavacUtils {
    private final Map<Element, Idents> identMap = new HashMap<Element, Idents>();
    public final Context ctx;
    public final Enter enter;
    public final Name.Table names;
    public final ClassReader reader;
    public final Target target;
    public final Check chk;
    public final Resolve rs;
    public final Symtab syms;
    public final Types types;
    public final TreeMaker make;
    public final Trees trees;
    public final Messager messager;
    public final ProcessingEnvironment processingEnv;
    public final RoundEnvironment env;
    public final Type voidType;

    public JavacUtils(ProcessingEnvironment processingEnv, RoundEnvironment env) {
        this.processingEnv = processingEnv;
        this.env = env;
        this.messager = processingEnv.getMessager();
        this.ctx = ((JavacProcessingEnvironment)JavacProcessingEnvironment.class.cast(processingEnv)).getContext();
        this.trees = Trees.instance(processingEnv);
        this.enter = Enter.instance(this.ctx);
        this.names = Name.Table.instance((Context)this.ctx);
        this.reader = ClassReader.instance(this.ctx);
        this.target = Target.instance(this.ctx);
        this.chk = Check.instance(this.ctx);
        this.syms = Symtab.instance(this.ctx);
        this.types = Types.instance(this.ctx);
        this.make = TreeMaker.instance(this.ctx);
        this.rs = Resolve.instance(this.ctx);
        try {
            Field f = Symtab.class.getField("voidType");
            this.voidType = (Type)Type.class.cast(f.get(this.syms));
        }
        catch (Exception ex) {
            throw new RuntimeException("Unsupported class, cannot get at voidType", ex);
        }
    }

    public static ExecutableElement findEnclosingExecutableElement(Element e) {
        while (e != null && !(e instanceof ExecutableElement)) {
            e = e.getEnclosingElement();
        }
        return (ExecutableElement)ExecutableElement.class.cast(e);
    }

    public static TypeElement findEnclosingTypeElement(Element e) {
        while (e != null && !(e instanceof TypeElement)) {
            e = e.getEnclosingElement();
        }
        return (TypeElement)TypeElement.class.cast(e);
    }

    public static PackageElement findEnclosingPackageElement(Element e) {
        while (e != null && !(e instanceof PackageElement)) {
            e = e.getEnclosingElement();
        }
        return (PackageElement)PackageElement.class.cast(e);
    }

    public Idents getIdents(Element e) {
        TypeElement te = JavacUtils.findEnclosingTypeElement(e);
        Idents idents = this.identMap.get(te);
        if (idents == null) {
            idents = new Idents();
            this.identMap.put(te, idents);
        }
        return idents;
    }

    public Name fromString(String name) {
        return this.names.fromString(name);
    }

    public Name fromString(String name, Object ... args) {
        return this.names.fromString(String.format(name, args));
    }

    public JCTree.JCExpression qualIdentAndLoad(Class<?> clazz) {
        return this.qualIdentAndLoad(clazz.getName());
    }

    public JCTree.JCExpression qualIdentAndLoad(String name) {
        return this.qualIdentAndLoad(this.names.fromString(name));
    }

    public JCTree.JCExpression qualIdentAndLoad(Name name) {
        return this.make.QualIdent(this.loadClass(name));
    }

    public List<JCTree.JCExpression> methodArguments(JCTree.JCMethodDecl md) {
        JCTree.JCExpression[] argv = new JCTree.JCExpression[((List)md.getParameters()).size()];
        int argc = 0;
        for (JCTree.JCVariableDecl var : md.getParameters()) {
            argv[argc++] = this.make.Ident(var);
        }
        return List.from(argv);
    }

    public JCTree.JCMethodInvocation call(Element e, int pos, Name methodName, Type returnType, List<JCTree.JCExpression> args) {
        Symbol.MethodSymbol msym = new Symbol.MethodSymbol(0L, methodName, returnType, (Symbol)Symbol.class.cast(e.getEnclosingElement()));
        JCTree.JCIdent expr = this.make.Ident(msym);
        expr.pos = pos;
        JCTree.JCMethodInvocation apply = this.make.Apply(List.<JCTree.JCExpression>nil(), expr, args);
        apply.pos = pos;
        return apply;
    }

    public JCTree.JCBlock block(int pos, JCTree.JCStatement ... statements) {
        return this.block(pos, List.from(statements));
    }

    public JCTree.JCBlock block(int pos, List<JCTree.JCStatement> statements) {
        JCTree.JCBlock b = this.make.Block(pos, statements);
        b.flags = 0L;
        return b;
    }

    public JCTree.JCBlock block(int pos, ListBuffer<JCTree.JCStatement> statements) {
        return this.block(pos, statements.toList());
    }

    public JCTree.JCMethodDecl createMethod(JCTree.JCClassDecl cd, int pos, long modifiers, Name n, Type returnType, List<JCTree.JCVariableDecl> paramList, List<JCTree.JCExpression> throwList, JCTree.JCBlock statements) {
        JCTree.JCMethodDecl m = this.createMethod(pos, modifiers, n, returnType, paramList, throwList, statements);
        cd.defs = cd.defs.append(m);
        return m;
    }

    public JCTree.JCMethodDecl createMethod(int pos, long modifiers, Name n, Type returnType, List<JCTree.JCVariableDecl> paramList, List<JCTree.JCExpression> throwList, JCTree.JCBlock statements) {
        JCTree.JCMethodDecl m = this.make.MethodDef(this.make.Modifiers(1L, List.<JCTree.JCAnnotation>nil()), n, this.make.Type(returnType), List.<JCTree.JCTypeParameter>nil(), paramList, throwList, statements, null);
        if (returnType != null) {
            m.setType(returnType);
        }
        m.getModifiers().flags = modifiers;
        m.mods.pos = pos;
        m.pos = pos;
        return m;
    }

    public int getElementPosition(Element e) {
        return this.getElementPosition(e, this.trees.getTree(e));
    }

    public int getElementPosition(Element e, Tree t) {
        return (int)this.trees.getSourcePositions().getStartPosition(this.trees.getPath(e).getCompilationUnit(), t);
    }

    public Symbol.ClassSymbol loadClass(Name name) {
        try {
            return this.reader.loadClass(name);
        }
        catch (ClassReader.BadClassFile err) {
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            throw ex;
        }
    }

    public Env<AttrContext> getEnv(Element e, Trees trees) {
        return this.enter.getTopLevelEnv((JCTree.JCCompilationUnit)trees.getPath(e).getCompilationUnit());
    }

    public JCTree.JCMethodInvocation makeCall(Element e, JCDiagnostic.DiagnosticPosition pos, int pos1, JCTree.JCExpression left, Name name, List<JCTree.JCExpression> args) {
        return this.makeCall(e, pos, pos1, left, left.type, name, args);
    }

    public JCTree.JCMethodInvocation makeCall(Element e, JCDiagnostic.DiagnosticPosition pos, int pos1, JCTree.JCExpression left, Type type, Name name, List<JCTree.JCExpression> args) {
        assert (type != null);
        Symbol.MethodSymbol funcsym = this.lookupMethod(e, pos, name, type, TreeInfo.types(args));
        JCTree.JCExpression sel = this.make.Select(left, funcsym);
        sel.setPos(pos1);
        JCTree.JCMethodInvocation app = this.make.App(sel, args);
        app.setPos(pos1);
        return app;
    }

    public Symbol.MethodSymbol lookupMethod(Element e, JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> argTypes) {
        return this.rs.resolveInternalMethod(pos, this.getEnv(e, this.trees), qual, name, argTypes, List.<Type>nil());
    }

    public static Map<Symbol.MethodSymbol, Attribute> getElementValues(Element te, Class annotationClass) {
        return JavacUtils.getElementValues(te, annotationClass.getName());
    }

    public static Map<Symbol.MethodSymbol, Attribute> getElementValues(Element te, String annotationClass) {
        Symbol cs = (Symbol)Symbol.class.cast(te);
        for (Attribute.Compound c : cs.getAnnotationMirrors()) {
            if (!annotationClass.equals(c.getAnnotationType().toString())) continue;
            return c.getElementValues();
        }
        return Collections.emptyMap();
    }

    public static Attribute getElementValue(Element te, Class annotationClass, String value) {
        return JavacUtils.getElementValue(te, annotationClass.getName(), value);
    }

    public static Attribute getElementValue(Element te, String annotationClass, String value) {
        Map<Symbol.MethodSymbol, Attribute> m = JavacUtils.getElementValues(te, annotationClass);
        for (Map.Entry<Symbol.MethodSymbol, Attribute> me : m.entrySet()) {
            if (!value.equals(((Name)me.getKey().getSimpleName()).toString())) continue;
            return me.getValue();
        }
        return null;
    }

    public static String getClassFileName(TypeElement element) {
        StringBuilder className = new StringBuilder(element.getQualifiedName().toString());
        if (element.getNestingKind() == NestingKind.MEMBER) {
            className.setCharAt(className.lastIndexOf("."), '$');
        }
        return className.toString();
    }

    public class Idents {
        private int classId;
        private int methId;

        public Name nextClassId() {
            return JavacUtils.this.fromString("%dr", this.classId++);
        }

        public Name nextMethId(Name methodName) {
            return JavacUtils.this.fromString("%s$%d", methodName.toString(), this.methId++);
        }
    }
}

