/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PatternFileFilter
implements FileFilter {
    protected static final String DOT = ".";
    protected static final String DOT_REGEX = "\\" + File.separator;
    private final String basePath;
    private final int basePathLength;
    private final Set<Pattern> patterns;
    private final Map<Pattern, Matcher> matchers;

    public PatternFileFilter(File baseDirectory) {
        this.basePath = baseDirectory.getAbsolutePath() + File.separator;
        this.basePathLength = this.basePath.length();
        this.patterns = new HashSet<Pattern>();
        this.matchers = new HashMap<Pattern, Matcher>();
    }

    public PatternFileFilter(File baseDirectory, Pattern ... patterns) {
        this(baseDirectory);
        this.addAll(patterns);
    }

    public PatternFileFilter(File baseDirectory, String ... patterns) {
        this(baseDirectory);
        this.addAll(patterns);
    }

    public PatternFileFilter(File baseDirectory, Collection<?> patterns) {
        this(baseDirectory);
        this.addAll(patterns);
    }

    protected final Matcher getMatcher(Pattern pattern, CharSequence seq) {
        if (this.matchers.containsKey(pattern)) {
            return this.matchers.get(pattern).reset(seq);
        }
        Matcher matcher = pattern.matcher(seq);
        this.matchers.put(pattern, matcher);
        return matcher;
    }

    public static String convertPackage(String pkg) {
        return pkg.replace(DOT, DOT_REGEX);
    }

    public final void add(Pattern pattern) {
        this.patterns.add(pattern);
    }

    public final void addAll(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            this.add(pattern);
        }
    }

    public final void addAll(Collection<?> patterns) {
        for (Object pattern : patterns) {
            if (pattern instanceof Pattern) {
                this.add((Pattern)pattern);
                continue;
            }
            if (pattern instanceof String) {
                this.add(Pattern.compile((String)pattern));
                continue;
            }
            throw new IllegalArgumentException("Elements of the collection must be either java.util.regex.Pattern or java.lang.String");
        }
    }

    public void add(String pattern) {
        this.add(Pattern.compile(pattern));
    }

    public final void addAll(String ... patterns) {
        for (String pattern : patterns) {
            this.add(pattern);
        }
    }

    public final boolean inScope(File file) {
        return file != null && file.getAbsolutePath().startsWith(this.basePath) && file.isFile() && file.canRead();
    }

    public final boolean matches(File file) {
        String path = file.getAbsolutePath().substring(this.basePathLength);
        for (Pattern pattern : this.patterns) {
            if (!this.getMatcher(pattern, path).matches()) continue;
            return true;
        }
        return false;
    }

    public static class Exclude
    extends PatternFileFilter {
        public Exclude(File baseDirectory) {
            super(baseDirectory);
        }

        public Exclude(File baseDirectory, Pattern ... patterns) {
            super(baseDirectory, patterns);
        }

        public Exclude(File baseDirectory, String ... patterns) {
            super(baseDirectory, patterns);
        }

        public Exclude(File baseDirectory, Collection<?> patterns) {
            super(baseDirectory, patterns);
        }

        @Override
        public boolean accept(File file) {
            return this.inScope(file) && !this.matches(file);
        }
    }

    public static class Include
    extends PatternFileFilter {
        public Include(File baseDirectory) {
            super(baseDirectory);
        }

        public Include(File baseDirectory, Pattern ... patterns) {
            super(baseDirectory, patterns);
        }

        public Include(File baseDirectory, String ... patterns) {
            super(baseDirectory, patterns);
        }

        public Include(File baseDirectory, Collection<?> patterns) {
            super(baseDirectory, patterns);
        }

        @Override
        public boolean accept(File file) {
            return this.inScope(file) && this.matches(file);
        }
    }
}

