/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import java.util.HashMap;
import java.util.Map;

public enum HttpResponseCode {
    INFORMATIONAL_CONTINUE(100, "Continue"),
    INFORMATIONAL_SWITCH_PROTOCOL(101, "Switching Protocols"),
    SUCCESS_OK(200, "OK"),
    SUCCESS_CREATED(201, "Created"),
    SUCCESS_ACCEPTED(202, "Accepted"),
    SUCCESS_NON_AUTHORITIVE_INFORMATION(203, "Non-Authoritative Information"),
    SUCCESS_NO_CONTENT(204, "No Content"),
    SUCCESS_RESET_CONTENT(205, "Reset Content"),
    SUCCESS_PARTIAL_CONTENT(206, "Partial Content"),
    REDIRECT_MULTIPLE_CHOICES(300, "Multiple Choices"),
    REDIRECT_MOVED_PERMANENTLY(301, "Moved Permanently"),
    REDIRECT_FOUND(302, "Found"),
    REDIRECT_SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    REDIRECT_USE_PROXY(305, "Use Proxy"),
    REDIRECT_UNUSED(306, "(Unused)"),
    REDIRECT_TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    ERROR_BAD_REQUEST(400, "Bad Request"),
    ERROR_UNAUTHORIZED(401, "Unauthorized"),
    ERROR_PAYMENT_REQUIRED(402, "Payment Required"),
    ERROR_FORBIDDEN(403, "Forbidden"),
    ERROR_NOT_FOUND(404, "Not Found"),
    ERROR_METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    ERROR_NOT_ACCEPTABLE(406, "Not Acceptable"),
    ERROR_PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    ERROR_REQUEST_TIMEOUT(408, "Request Timeout"),
    ERROR_CONFLICT(409, "Conflict"),
    ERROR_GONE(410, "Gone"),
    ERROR_LENGTH_REQUIRED(411, "Length Required"),
    ERROR_PRECONDITION_FAILED(412, "Precondition Failed"),
    ERROR_REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    ERROR_REQUEST_URI_TOO_LARGE(414, "Request-URI Too Large"),
    ERROR_UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    ERROR_REQUESTED_RANGE_NOT_SATISTIABLE(416, "Requested Range Not Satisfiable"),
    ERROR_EXPECTATION_FAILED(417, "Expectation Failed"),
    SERVERERROR_INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    SERVERERROR_NOT_IMPLEMENTED(501, "Not Implemented"),
    SERVERERROR_BAD_GATEWAY(502, "Bad Gateway"),
    SERVERERROR_SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    SERVERERROR_GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    SERVERERROR_HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version not supported");

    private final int code;
    private final String desc;
    private static final Map<Integer, HttpResponseCode> map;

    public static HttpResponseCode valueOf(int code) {
        HttpResponseCode c = map.get(code);
        if (c == null) {
            throw new IllegalArgumentException("Unsupported HTTP error code " + code);
        }
        return c;
    }

    private HttpResponseCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.desc;
    }

    static {
        map = new HashMap<Integer, HttpResponseCode>();
        for (HttpResponseCode c : HttpResponseCode.values()) {
            map.put(c.getCode(), c);
        }
    }
}

