/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import uk.org.retep.util.mime.ContentType;

public class ImageUtils {
    private ImageUtils() {
    }

    public static final Graphics2D createDummyGraphics() {
        BufferedImage bi = new BufferedImage(100, 100, 6);
        return bi.createGraphics();
    }

    public static int getImageType(ContentType contentType) {
        switch (contentType) {
            case IMAGE_JPEG: {
                return 5;
            }
            case IMAGE_GIF: {
                return 13;
            }
            case IMAGE_PNG: {
                return 6;
            }
            case IMAGE_PGM: {
                return 10;
            }
            case IMAGE_RGB: 
            case IMAGE_PNM: 
            case IMAGE_PPM: {
                return 1;
            }
        }
        throw new IllegalStateException("Unsupported Image type for " + (Object)((Object)contentType));
    }

    public static byte[] toArray(RenderedImage image, ContentType contentType) throws IOException {
        Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType(contentType.getMimeType());
        if (!it.hasNext()) {
            throw new IllegalStateException("Unsupported MimeType " + contentType.getMimeType());
        }
        ImageWriter writer = it.next();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        writer.setOutput(ios);
        writer.write(image);
        ios.flush();
        writer.dispose();
        return baos.toByteArray();
    }
}

