/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.map;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import uk.org.retep.util.collections.map.Timestamp;
import uk.org.retep.util.collections.map.TimestampedMap;

public class TimestampedHashMap<E>
extends TreeMap<Timestamp, E>
implements TimestampedMap<E> {
    static final long serialVersionUID = -7193127234818772335L;
    private TimeUnit timeUnit;
    private int maxSize;

    public TimestampedHashMap() {
        this(0, TimeUnit.MILLISECONDS);
    }

    public TimestampedHashMap(TimeUnit unit) {
        this(0, unit);
    }

    public TimestampedHashMap(int maxSize) {
        this(maxSize, TimeUnit.MILLISECONDS);
    }

    public TimestampedHashMap(int maxSize, TimeUnit unit) {
        this.timeUnit = unit;
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if (maxSize > 0) {
            while (this.size() > maxSize) {
                this.removeOldestEntry();
            }
        }
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void setTimeUnit(TimeUnit unit) {
        this.timeUnit = unit;
        for (Timestamp t : this.keySet()) {
            TimeUnit oldUnit = t.getTimeUnit();
            t.setTimeStamp(this.timeUnit.convert(t.getTimeStamp(), oldUnit));
            t.setTimeUnit(this.timeUnit);
        }
    }

    @Override
    public final Set<Map.Entry<Timestamp, E>> entrySet(Calendar start, Calendar end) {
        return this.entrySet(start.getTimeInMillis(), end.getTimeInMillis());
    }

    @Override
    public final Set<Map.Entry<Timestamp, E>> entrySet(Date start, Date end) {
        return this.entrySet(start.getTime(), end.getTime());
    }

    @Override
    public final Set<Map.Entry<Timestamp, E>> entrySet(long start, long end) {
        return this.entrySet(start, end, TimeUnit.MILLISECONDS);
    }

    @Override
    public final Set<Map.Entry<Timestamp, E>> entrySet(long start, long end, TimeUnit unit) {
        return this.entrySet(start, unit, end, unit);
    }

    @Override
    public Set<Map.Entry<Timestamp, E>> entrySet(long start, TimeUnit startUnit, long end, TimeUnit endUnit) {
        HashSet ret = new HashSet();
        for (Map.Entry e : this.entrySet()) {
            if (!((Timestamp)e.getKey()).between(start, startUnit, end, endUnit)) continue;
            ret.add(e);
        }
        return ret;
    }

    @Override
    public final void put(Calendar timestamp, E value) {
        this.put(timestamp.getTimeInMillis(), TimeUnit.MILLISECONDS, value);
    }

    @Override
    public final void put(Date timestamp, E value) {
        this.put(timestamp.getTime(), TimeUnit.MILLISECONDS, value);
    }

    @Override
    public final void put(long timestamp, E value) {
        this.put(timestamp, this.getTimeUnit(), value);
    }

    @Override
    public void put(long timestamp, TimeUnit unit, E value) {
        this.put(new Timestamp(timestamp, unit), value);
    }

    @Override
    public E put(Timestamp t, E value) {
        E ret = super.put(t, value);
        if (this.maxSize > 0 && this.size() > this.maxSize) {
            this.removeOldestEntry();
        }
        return ret;
    }

    public Map.Entry<Timestamp, E> removeOldestEntry() {
        Iterator it = this.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry e = it.next();
            it.remove();
            return e;
        }
        return null;
    }

    @Override
    public final E get(Calendar timestamp) {
        return this.get(timestamp.getTimeInMillis());
    }

    @Override
    public final E get(Date timestamp) {
        return this.get(timestamp.getTime());
    }

    @Override
    public final E get(long timestamp) {
        return this.get(this.getTimeUnit().convert(timestamp, TimeUnit.MILLISECONDS));
    }

    @Override
    public E get(long timestamp, TimeUnit unit) {
        return (E)this.get(new Timestamp(timestamp, unit));
    }

    @Override
    public final Collection<E> get(Calendar start, Calendar end) {
        return this.get(start.getTimeInMillis(), end.getTimeInMillis());
    }

    @Override
    public final Collection<E> get(Date start, Date end) {
        return this.get(start.getTime(), end.getTime());
    }

    @Override
    public final Collection<E> get(long start, long end) {
        return this.get(start, end, TimeUnit.MILLISECONDS);
    }

    @Override
    public final Collection<E> get(long start, long end, TimeUnit unit) {
        return this.get(start, unit, end, unit);
    }

    @Override
    public Collection<E> get(long start, TimeUnit startUnit, long end, TimeUnit endUnit) {
        ArrayList ret = new ArrayList();
        for (Map.Entry e : this.entrySet()) {
            if (!((Timestamp)e.getKey()).between(start, startUnit, end, endUnit)) continue;
            ret.add(e.getValue());
        }
        return ret;
    }
}

