/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> int getNonNullCount(T ... values) {
        int size = 0;
        for (T value : values) {
            if (value == null) continue;
            ++size;
        }
        return size;
    }

    public static <T> T[] toArrayRemovingNulls(T ... values) {
        Object[] array = (Object[])Array.newInstance(values.getClass(), ArrayUtils.getNonNullCount(values));
        int p = 0;
        for (T value : values) {
            if (value == null) continue;
            array[p++] = value;
        }
        return array;
    }

    @Deprecated
    public static <T> List<T> createList(T[] array) {
        ArrayList l = new ArrayList(array.length);
        ArrayUtils.addAll(l, array);
        return l;
    }

    public static <T> boolean addAll(List<T> list, T[] array) {
        boolean changed = false;
        for (T element : array) {
            changed |= list.add(element);
        }
        return changed;
    }

    public static <T> boolean addAll(Set<T> list, T[] array) {
        boolean changed = false;
        for (T element : array) {
            changed |= list.add(element);
        }
        return changed;
    }

    public static final boolean equals(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(char[] array1, int offset1, char[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(short[] array1, int offset1, short[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(int[] array1, int offset1, int[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(long[] array1, int offset1, long[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(float[] array1, int offset1, float[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(double[] array1, int offset1, double[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            if (array1[i] != array2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean equals(Object[] array1, int offset1, Object[] array2, int offset2, int length) {
        if (array1 == null || array2 == null || offset1 + length > array1.length || offset2 + length > array2.length) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        for (int k = 0; k < length; ++k) {
            Object o1 = array1[i];
            Object o2 = array2[i];
            if (!(o1 != null ? o1.equals(o2) : o2 == null)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static <T> Set<T> toSet(T ... a) {
        HashSet<T> set = new HashSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> Set<T> toConcurrentSet(T ... a) {
        ConcurrentSkipListSet<T> set = new ConcurrentSkipListSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> Iterator<T> iterator(final T ... a) {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < a.length;
            }

            @Override
            public T next() {
                return a[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported on arrays");
            }
        };
    }

    public static int[] convertBytesToInts(byte[] src) {
        return ArrayUtils.convertBytesToInts(src, 0, src.length);
    }

    public static int[] convertBytesToInts(byte[] src, int offset, int length) {
        if (length % 4 != 0) {
            throw new IllegalStateException("Number of bytes must be multiple of 4.");
        }
        int end = offset + length;
        if (end > src.length) {
            throw new IndexOutOfBoundsException();
        }
        int[] dst = new int[length >> 2];
        int i = offset;
        int j = 0;
        while (i < end) {
            dst[j] = (src[i] << 24) + (src[i + 1] << 16) + (src[i + 2] << 8) + src[i + 3];
            i += 4;
            ++j;
        }
        return dst;
    }

    public static short[] convertBytesToShorts(byte[] src) {
        return ArrayUtils.convertBytesToShorts(src, 0, src.length);
    }

    public static short[] convertBytesToShorts(byte[] src, int offset, int length) {
        if (length % 2 != 0) {
            throw new IllegalStateException("Number of bytes must be multiple of 4.");
        }
        int end = offset + length;
        if (end > src.length) {
            throw new IndexOutOfBoundsException();
        }
        short[] dst = new short[length >> 1];
        int i = offset;
        int j = 0;
        while (i < end) {
            dst[j] = (short)((src[i] << 8) + src[i + 1]);
            i += 2;
            ++j;
        }
        return dst;
    }
}

