/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model;

import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;

public abstract class AbstractModel<T>
implements ComboBoxModel {
    private Object selected;
    private T defaultValue;
    private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

    public AbstractModel(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final void setModel(JComboBox component) {
        component.setModel(this);
        component.setRenderer(this.getRenderer());
        component.setSelectedItem(this.getDefaultValue());
    }

    public final void setModel(JList component) {
        component.setModel(this);
        component.setCellRenderer(this.getRenderer());
        component.setSelectedValue(this.getDefaultValue(), true);
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract ListCellRenderer getRenderer();

    public final T getSelected() {
        return (T)this.getSelectedItem();
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract Object getElementAt(int var1);

    @Override
    public final void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public final void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = anItem == null ? this.defaultValue : anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected == null ? this.defaultValue : this.selected;
    }
}

