/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.io.IOException;
import java.io.OutputStream;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.LogFactory;
import uk.org.retep.util.string.StringUtils;

public class OutputStreamLogger
extends OutputStream {
    private static int counter = 0;
    private OutputStream out;
    private Log log;
    private char[] logBuf = new char[16];
    private int logBufPos = 0;
    private long logBufTotal = 0L;

    public OutputStreamLogger(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("OutputStream may not be null");
        }
        this.out = out;
        this.log = LogFactory.getLog("Output_" + ++counter, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        char[] cArray = this.logBuf;
        synchronized (this.logBuf) {
            if (this.logBufPos > 0) {
                int i;
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("%06x ", this.logBufTotal));
                int s = Math.min(this.logBufPos, this.logBuf.length);
                for (i = 0; i < s; ++i) {
                    sb.append(this.logBuf[i] > '\u001f' && this.logBuf[i] < '\u007f' ? this.logBuf[i] : (char)'.');
                }
                for (i = s; i < this.logBuf.length; ++i) {
                    sb.append(' ');
                }
                sb.append(" :");
                for (i = 0; i < s; ++i) {
                    char v = this.logBuf[i];
                    sb.append(StringUtils.encodeHex(v >>> 4 & 0xF));
                    sb.append(StringUtils.encodeHex(v >>> 0 & 0xF));
                    sb.append(' ');
                }
                this.log.info(sb);
                this.logBufTotal += (long)this.logBufPos;
                this.logBufPos = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int add(int c) {
        char[] cArray = this.logBuf;
        synchronized (this.logBuf) {
            if (c > -1) {
                this.logBuf[this.logBufPos++] = (char)c;
                if (this.logBufPos >= this.logBuf.length) {
                    this.dump();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return c;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
        this.add(b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.write(b, 0, b.length);
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), ex);
            throw ex;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
        this.log.info("write( %d, %d )", off, len);
        for (int i = 0; i < len; ++i) {
            this.add(b[off + i]);
        }
        this.dump();
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.dump();
                this.out.close();
                this.out = null;
            }
            catch (IOException ex) {
                this.log.error((Object)ex.getMessage(), ex);
                throw ex;
            }
        }
    }
}

