/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.logging;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.Log4JHandler;

public class LogFactory {
    public static Log getLog(Class clazz) {
        return new Log(clazz);
    }

    public static Log getLog(String name, Object ... args) {
        return new Log(name, args);
    }

    private LogFactory() {
    }

    public static void configureLog4J() {
        DOMConfigurator.configure((URL)LogFactory.class.getResource("/log4j.xml"));
    }

    public static void configureLog4J(File homeDirectory) throws MalformedURLException {
        LogFactory.configureLog4J(homeDirectory, "log4j.xml");
    }

    public static void configureLog4J(File homeDirectory, String name) throws MalformedURLException {
        File logFile = new File(homeDirectory, name);
        if (logFile.exists() && logFile.isFile() && logFile.canRead()) {
            DOMConfigurator.configure((URL)logFile.toURI().toURL());
        } else {
            LogFactory.configureLog4J();
        }
    }

    static {
        try {
            Logger logger = Logger.getLogger("");
            Handler[] handlers = logger.getHandlers();
            if (handlers != null && handlers.length > 0) {
                for (Handler handler : handlers) {
                    logger.removeHandler(handler);
                }
            }
            logger.addHandler(new Log4JHandler());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

