/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.LogFactory;

public abstract class ConcurrencySupport {
    private static final boolean DETECT_DEADLOCK = System.getProperty("retep.detect.deadlock") != null;
    private Log log;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = DETECT_DEADLOCK ? new DebugLock("ReadLock", this.lock.readLock()) : this.lock.readLock();
    private Lock writeLock = DETECT_DEADLOCK ? new DebugLock("WriteLock", this.lock.writeLock()) : this.lock.writeLock();
    private Exception lockOwner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shareLock(ConcurrencySupport parent) {
        Lock oldWriteLock = this.writeLock;
        oldWriteLock.lock();
        try {
            Lock parentWriteLock = parent.writeLock;
            parentWriteLock.lock();
            try {
                this.lock = parent.lock;
                this.readLock = parent.readLock;
                this.writeLock = parent.writeLock;
            }
            finally {
                parentWriteLock.unlock();
            }
        }
        finally {
            oldWriteLock.unlock();
        }
    }

    protected final Log getLog() {
        if (this.log == null) {
            this.setLog(this.getClass());
        }
        return this.log;
    }

    protected final void setLog(Class clazz) {
        this.log = LogFactory.getLog(clazz);
    }

    protected final Lock writeLock() {
        return this.writeLock;
    }

    protected final Lock readLock() {
        return this.readLock;
    }

    private class DebugLock
    implements Lock {
        private final String type;
        private final Lock lock;

        public DebugLock(String type, Lock lock) {
            this.type = type;
            this.lock = lock;
        }

        @Override
        public void lock() {
            try {
                if (!this.lock.tryLock(1L, TimeUnit.SECONDS)) {
                    Exception e = new Exception("Blocked Thread StackTrace", ConcurrencySupport.this.lockOwner);
                    e.fillInStackTrace();
                    ConcurrencySupport.this.getLog().warn("lock %s is blocked", e, this.type);
                    this.lock.lock();
                    ConcurrencySupport.this.getLog().warn("lock %s has now been released", this.type);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConcurrencySupport.this.lockOwner = new Exception("Thread owning " + this.type + " lock");
            ConcurrencySupport.this.lockOwner.fillInStackTrace();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.lock.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }
    }
}

