/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uk.org.retep.util.classloader.CachingClassLoader;
import uk.org.retep.util.io.FileUtils;

public class DeploymentClassLoader
extends CachingClassLoader {
    private final Set<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();

    public DeploymentClassLoader() {
    }

    public DeploymentClassLoader(ClassLoader parent) {
        super(parent);
    }

    public DeploymentClassLoader(File directory) throws IOException {
        this.init(directory);
    }

    public DeploymentClassLoader(File directory, ClassLoader parent) throws IOException {
        super(parent);
        this.init(directory);
    }

    private void init(File directory) throws IOException {
        List<File> files = FileUtils.findFiles(directory, FileUtils.JAR_FILTER, false);
        for (File file : files) {
            this.add(new URLClassLoader(new URL[]{file.toURI().toURL()}));
        }
    }

    public boolean add(ClassLoader loader) {
        return this.loaders.add(loader);
    }

    public boolean remove(ClassLoader loader) {
        return this.loaders.remove(loader);
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.getClass(className);
        if (c == null) {
            Iterator<ClassLoader> it = this.loaders.iterator();
            while (c == null && it.hasNext()) {
                try {
                    c = it.next().loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {}
            }
            if (c == null) {
                throw new ClassNotFoundException("Unable to find class " + className);
            }
            this.putClass(className, c);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected URL findResource(String name) {
        Iterator<ClassLoader> it = this.loaders.iterator();
        while (it.hasNext()) {
            URL url = it.next().getResource(name);
            if (url == null) continue;
            return null;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

