/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.mojo.packaging;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import uk.org.retep.mojo.util.AbstractMojo;
import uk.org.retep.mojo.util.MavenUtils;
import uk.org.retep.util.io.FileUtils;

public class SimplePackagingMojo
extends AbstractMojo {
    protected boolean includeDependencies;
    protected String scope = null;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Artifact> artifacts = MavenUtils.getProjectArtifacts(this.mavenProject, this.artifactFactory, this.resolver, this.artifactMetadataSource, this.remoteRepositories, this.localRepository, this.scope, this.includeDependencies);
        if (this.outputDirectory.mkdirs()) {
            this.getLog().info((CharSequence)("Created " + this.outputDirectory.getPath()));
        }
        try {
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                File destFile = null;
                try {
                    MavenProject proj = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, true);
                    String packaging = proj.getPackaging();
                    String finalName = proj.getBuild().getFinalName();
                    for (Object ext : proj.getBuild().getExtensions()) {
                        System.out.println(ext.getClass());
                    }
                    destFile = new File(this.outputDirectory, finalName + "." + artifact.getType());
                }
                catch (ProjectBuildingException pbe) {
                    // empty catch block
                }
                if (destFile == null) {
                    destFile = new File(this.outputDirectory, file.getName());
                }
                this.getLog().info((CharSequence)("Installing " + destFile));
                FileUtils.copyFile((File)file, (File)destFile);
            }
        }
        catch (IOException ioe) {
            throw new MojoFailureException(ioe.getMessage());
        }
    }
}

