/*
 * Decompiled with CFR 0.152.
 */
package uk.num.tnum.validators;

import java.util.regex.Pattern;
import uk.num.validators.ValidationResult;

public class NumTNumValidator {
    private static final Pattern regex = Pattern.compile("\\+\\d{2,15}");

    private NumTNumValidator() {
    }

    public static ValidationResult validate(String tnum) {
        ValidationResult validationResult = new ValidationResult();
        if (tnum == null) {
            validationResult.addMessage(ValidationResult.ErrorCode.NULL_UNACCEPTABLE, "tnum");
        } else if (regex.matcher(tnum).matches()) {
            return ValidationResult.VALID_NO_ERRORS;
        }
        validationResult.addMessage(ValidationResult.ErrorCode.PATTERN_MISMATCH, tnum);
        return validationResult;
    }
}

