/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.util;

import java.net.IDN;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.util.HashUtils;
import uk.num.numlib.util.LookupGenerator;
import uk.num.numlib.util.StringConstants;

public abstract class BaseLookupGenerator
implements LookupGenerator {
    public static final String NUM_PROTOCOL = "num://";
    public static final String HTTPS_PROTOCOL = "https://";
    public static final String HTTP_PROTOCOL = "http://";
    protected final String numId;
    protected String branch;
    protected String domain;

    public BaseLookupGenerator(@NonNull String numId) {
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        this.numId = numId;
    }

    protected static String normaliseDomainName(@NonNull String numId) {
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        if (numId.startsWith("http")) {
            String host = BaseLookupGenerator.parseNumUriString(numId).getDomain();
            return BaseLookupGenerator.normaliseDomainName(host);
        }
        String result = numId;
        if (result.startsWith("www.")) {
            result = result.substring(4);
        }
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        if (!StringUtils.isAsciiPrintable((CharSequence)result)) {
            Object[] parts = result.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                if (StringUtils.isAsciiPrintable((CharSequence)parts[i])) continue;
                parts[i] = IDN.toASCII((String)parts[i]);
            }
            result = StringUtils.join((Object[])parts, (String)".");
        }
        return result;
    }

    protected static String normalisePath(String path) {
        String result = "";
        if (path != null && !path.isEmpty()) {
            Object[] pathComponents = path.split("[/]");
            ArrayUtils.reverse((Object[])pathComponents);
            if (pathComponents.length > 0 && ((String)pathComponents[0]).contains(".")) {
                pathComponents[0] = "";
            }
            for (int i = 0; i < pathComponents.length; ++i) {
                if (StringUtils.isAsciiPrintable((CharSequence)pathComponents[i])) continue;
                pathComponents[i] = IDN.toASCII((String)pathComponents[i]);
            }
            if (pathComponents.length > 0) {
                result = StringUtils.join((Object[])pathComponents, (String)".");
                if ((result = result.replaceAll(" ", "_")).startsWith(".")) {
                    result = result.substring(1);
                }
                if (result.endsWith(".")) {
                    result = result.substring(0, result.length() - 1);
                }
            }
        }
        return result;
    }

    public static LookupGenerator.NumUriComponents parseNumUriString(@NonNull String possibleNumUri) {
        if (possibleNumUri == null) {
            throw new NullPointerException("possibleNumUri is marked @NonNull but is null");
        }
        String withoutProtocol = StringUtils.removeStartIgnoreCase((String)possibleNumUri, (String)HTTP_PROTOCOL);
        withoutProtocol = StringUtils.removeStartIgnoreCase((String)withoutProtocol, (String)HTTPS_PROTOCOL);
        withoutProtocol = StringUtils.removeStartIgnoreCase((String)withoutProtocol, (String)NUM_PROTOCOL);
        String[] urlAndParams = withoutProtocol.split("\\?");
        String[] parts = urlAndParams[0].split("/");
        String[] domainAndModuleNumber = parts[0].split(":");
        int moduleNumber = 0;
        if (domainAndModuleNumber.length > 1) {
            try {
                moduleNumber = Integer.parseInt(domainAndModuleNumber[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String path = "/";
        if (parts.length > 1) {
            CharSequence[] tailParts = Arrays.copyOfRange(parts, 1, parts.length);
            path = "/" + String.join((CharSequence)"/", tailParts);
        }
        String params = urlAndParams.length > 1 ? urlAndParams[1] : null;
        return new LookupGenerator.NumUriComponents(domainAndModuleNumber[0], moduleNumber, path, params);
    }

    @Override
    public String getIndependentLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String result = this.getRootIndependentLocation(moduleNumber);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public String getHostedLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String result = this.getRootHostedLocation(moduleNumber);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public boolean isDomainRoot() {
        return this.branch == null;
    }

    protected String transformBranch(String s) {
        if (s == null || s.equals("/")) {
            return null;
        }
        int i = s.indexOf("/");
        Object[] split = s.substring(i + 1).split("/");
        ArrayUtils.reverse((Object[])split);
        for (int j = 0; j < split.length; ++j) {
            if (StringUtils.isAsciiPrintable((CharSequence)split[j])) continue;
            split[j] = IDN.toASCII((String)split[j]);
        }
        return String.join((CharSequence)".", (CharSequence[])split);
    }

    @Override
    public String getPopulatorLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        if (this.branch != null) {
            return null;
        }
        return moduleNumber + "." + "_" + this.domain + StringConstants.POPULATOR_SERVICE_SUFFIX + ".";
    }

    @Override
    public String getRootIndependentLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        return moduleNumber + "._num." + this.domain + ".";
    }

    @Override
    public String getRootHostedLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        return moduleNumber + "." + "_" + this.domain + HashUtils.hash3(this.domain) + StringConstants.HOSTED_RECORD_SUFFIX + ".";
    }

    @Override
    public String getRootIndependentLocationNoModuleNumber(LookupGenerator.TrailingDot addTrailingDot) {
        if (addTrailingDot == LookupGenerator.TrailingDot.ADD_TRAILING_DOT) {
            return "_num." + this.domain + ".";
        }
        return "_num." + this.domain;
    }

    @Override
    public String getRootHostedLocationNoModuleNumber(LookupGenerator.TrailingDot addTrailingDot) {
        if (addTrailingDot == LookupGenerator.TrailingDot.ADD_TRAILING_DOT) {
            return "_" + this.domain + HashUtils.hash3(this.domain) + StringConstants.HOSTED_RECORD_SUFFIX + ".";
        }
        return "_" + this.domain + HashUtils.hash3(this.domain) + StringConstants.HOSTED_RECORD_SUFFIX;
    }
}

