/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.service;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.Record;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.util.BaseLookupGenerator;
import uk.num.numlib.util.DomainLookupGenerator;
import uk.num.numlib.util.EmailLookupGenerator;

public class IndependentRecordLookupService {
    public static final int MAX_SANE_NUMID_LENGTH = 255;
    private final DNSServices dnsServices;

    public String loadRecordFromIndependentZone(@NonNull String numIdName, @NonNull String path, int module, int timeoutMs) throws NumInvalidParameterException, NumInvalidDNSQueryException, RrSetIncompleteException, RrSetNoHeadersException, RrSetHeaderFormatException {
        if (numIdName == null) {
            throw new NullPointerException("numIdName is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        this.validateParameters(numIdName, path, module, timeoutMs);
        BaseLookupGenerator generator = numIdName.contains("@") ? new EmailLookupGenerator(numIdName + path) : new DomainLookupGenerator(numIdName + path);
        try {
            Record[] records = this.dnsServices.getRecordFromDnsNoCache(generator.getIndependentLocation(module), timeoutMs);
            if (records != null && records.length > 0) {
                return this.dnsServices.rebuildTXTRecordContent(records);
            }
        }
        catch (NumNoRecordAvailableException e) {
            return null;
        }
        return null;
    }

    private void validateParameters(@NonNull String numIdName, @NonNull String path, int module, int timeoutMs) throws NumInvalidParameterException {
        if (numIdName == null) {
            throw new NullPointerException("numIdName is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        if (StringUtils.isBlank((CharSequence)numIdName) || numIdName.length() > 255) {
            throw new NumInvalidParameterException(String.format("numIdName is null, blank, or longer than 255 characters: '%s'", numIdName));
        }
        if (path.length() > 255) {
            throw new NumInvalidParameterException(String.format("path is longer than 255 characters: '%s'", path));
        }
        if (module < 0) {
            throw new NumInvalidParameterException("module number cannot be negative.");
        }
        if (timeoutMs <= 0) {
            throw new NumInvalidParameterException("timeoutMs cannot be negative or zero.");
        }
    }

    public IndependentRecordLookupService(DNSServices dnsServices) {
        this.dnsServices = dnsServices;
    }
}

