/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.NonNull;
import uk.modl.interpreter.JsonToString;
import uk.modl.interpreter.ModlToJson;
import uk.modl.interpreter.model.Modl;
import uk.modl.interpreter.parser.Parser;

public final class Interpreter {
    public static String interpretToJsonString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        JsonNode jsonObject = Interpreter.interpretToJsonObject(s);
        return JsonToString.convert(jsonObject);
    }

    public static String interpretToPrettyJsonString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        JsonNode jsonObject = Interpreter.interpretToJsonObject(s);
        return JsonToString.convertPretty(jsonObject);
    }

    public static JsonNode interpretToJsonObject(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Modl modl = Interpreter.interpret(s);
        return ModlToJson.convert(modl);
    }

    public static Modl interpret(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return Parser.parseModl(s);
    }

    private Interpreter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

