/*
 * Decompiled with CFR 0.152.
 */
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.interpreter.Interpreter;

public class Interpret {
    private static final Logger log = LogManager.getLogger(Interpret.class);
    private static final Interpreter interpreter = new Interpreter();

    public static void main(String ... args) {
        if (args.length == 0) {
            log.info("Usage: java -jar ./build/libs/interpreter-<version>.jar <modl-file-name> [modl-file-name] ...");
        }
        int sum = Arrays.stream(args).mapToInt(filename -> {
            try {
                List<String> allLines = Files.readAllLines(Paths.get(filename, new String[0]));
                String modlString = String.join((CharSequence)"\n", allLines);
                String result = interpreter.interpretToPrettyJsonString(modlString);
                log.info(result);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return 1;
            }
            return 0;
        }).sum();
        System.exit(sum);
    }
}

