/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.model.Modl;
import uk.modl.model.ModlArray;
import uk.modl.model.ModlBoolNull;
import uk.modl.model.ModlFloat;
import uk.modl.model.ModlInteger;
import uk.modl.model.ModlMap;
import uk.modl.model.ModlPair;
import uk.modl.model.ModlPrimitive;
import uk.modl.model.ModlString;
import uk.modl.model.ModlStructure;
import uk.modl.model.ModlValue;
import uk.modl.parser.antlr.MODLParser;

public final class ModlParsedVisitor {
    private static final Logger log = LogManager.getLogger(ModlParsedVisitor.class);

    public static final Modl visitModl(@NonNull MODLParser.ModlContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        List children = ctx.children.stream().filter(ModlParsedVisitor::nonTerminal).collect(Collectors.toList());
        if (children.size() == 1 && children.get(0) instanceof MODLParser.Modl_primitiveContext) {
            ModlPrimitive prim = ModlParsedVisitor.visitModlPrimitive((MODLParser.Modl_primitiveContext)((Object)children.get(0)));
            return new Modl(Arrays.asList(prim));
        }
        List<ModlStructure> structures = children.stream().map(ModlParsedVisitor::visitModlStructure).collect(Collectors.toList());
        if (structures != null && !structures.isEmpty()) {
            return new Modl(structures);
        }
        return new Modl(new ArrayList<ModlStructure>());
    }

    private static ModlStructure visitModlStructure(@NonNull ParseTree ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (ctx instanceof MODLParser.Modl_mapContext) {
            return ModlParsedVisitor.visitModlMap((MODLParser.Modl_mapContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_arrayContext) {
            return ModlParsedVisitor.visitModlArray((MODLParser.Modl_arrayContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_pairContext) {
            return ModlParsedVisitor.visitModlPair((MODLParser.Modl_pairContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_structureContext) {
            MODLParser.Modl_structureContext sctx = (MODLParser.Modl_structureContext)ctx;
            if (sctx.children.size() == 1) {
                return ModlParsedVisitor.visitModlStructure((ParseTree)sctx.children.get(0));
            }
        }
        return new ModlMap(new ArrayList<ModlPair>());
    }

    private static ModlPair visitModlPair(@NonNull MODLParser.Modl_pairContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (ctx.children == null) {
            String message = "No children: " + ((Object)((Object)ctx)).getClass().getName();
            log.error(message);
            return new ModlPair("Error", new ModlString(message));
        }
        String key = ((ParseTree)ctx.children.get(0)).getText();
        ModlParsedVisitor.validateKey(key);
        ParseTree value = ctx.children.get(1) instanceof TerminalNode ? (ParseTree)ctx.children.get(2) : (ParseTree)ctx.children.get(1);
        ModlStructure pairValue = ModlParsedVisitor.visitChild(value);
        return new ModlPair(key, pairValue);
    }

    private static ModlArray visitModlArray(@NonNull MODLParser.Modl_arrayContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        List<ModlValue> children = ctx.children.stream().filter(ModlParsedVisitor::nonTerminal).map(ModlParsedVisitor::visitChild).map(ModlValue.class::cast).collect(Collectors.toList());
        if (children != null && !children.isEmpty()) {
            return new ModlArray(children);
        }
        return new ModlArray(new ArrayList<ModlValue>());
    }

    private static ModlMap visitModlMap(@NonNull MODLParser.Modl_mapContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        List<ModlPair> children = ctx.children.stream().filter(ModlParsedVisitor::nonTerminal).map(ModlParsedVisitor::visitChild).map(ModlPair.class::cast).collect(Collectors.toList());
        if (children != null && !children.isEmpty()) {
            return new ModlMap(children);
        }
        return new ModlMap(new ArrayList<ModlPair>());
    }

    private static ModlStructure visitModlValue(@NonNull MODLParser.Modl_valueContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (ctx.children != null && !ctx.children.isEmpty()) {
            return ModlParsedVisitor.visitChild((ParseTree)ctx.children.get(0));
        }
        String message = "No children: " + ((Object)((Object)ctx)).getClass().getName();
        log.error(message);
        return new ModlString(message);
    }

    private static ModlPrimitive visitModlPrimitive(@NonNull MODLParser.Modl_primitiveContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        String text = ctx.getText();
        if (text == null || text.equals("null") || text.equals("000")) {
            return ModlBoolNull.MODL_NULL;
        }
        if (text.equals("false") || text.equals("00")) {
            return ModlBoolNull.MODL_FALSE;
        }
        if (text.equals("true") || text.equals("01")) {
            return ModlBoolNull.MODL_TRUE;
        }
        try {
            int intValue = Integer.parseInt(text, 10);
            if (Integer.toString(intValue).equals(text)) {
                return new ModlInteger(intValue);
            }
        }
        catch (NumberFormatException intValue) {
            // empty catch block
        }
        try {
            float floatValue = Float.parseFloat(text);
            if (Float.toString(floatValue).equals(text)) {
                return new ModlFloat(floatValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ModlString(text);
    }

    private static boolean nonTerminal(@NonNull ParseTree tree) {
        if (tree == null) {
            throw new NullPointerException("tree is marked non-null but is null");
        }
        return !(tree instanceof TerminalNode);
    }

    private static ModlStructure visitChild(@NonNull ParseTree ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (ctx instanceof MODLParser.Modl_mapContext) {
            return ModlParsedVisitor.visitModlMap((MODLParser.Modl_mapContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_arrayContext) {
            return ModlParsedVisitor.visitModlArray((MODLParser.Modl_arrayContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_pairContext) {
            return ModlParsedVisitor.visitModlPair((MODLParser.Modl_pairContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_structureContext) {
            return ModlParsedVisitor.visitModlStructure(ctx);
        }
        if (ctx instanceof MODLParser.Modl_pairContext) {
            return ModlParsedVisitor.visitModlPair((MODLParser.Modl_pairContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_valueContext) {
            return ModlParsedVisitor.visitModlValue((MODLParser.Modl_valueContext)ctx);
        }
        if (ctx instanceof MODLParser.Modl_primitiveContext) {
            return ModlParsedVisitor.visitModlPrimitive((MODLParser.Modl_primitiveContext)ctx);
        }
        String message = "Unknown object: " + ctx.getClass().getName();
        log.error(message);
        return new ModlString(message);
    }

    private static void validateKey(@NonNull String k) {
        if (k == null) {
            throw new NullPointerException("k is marked non-null but is null");
        }
        if (k.contains("%")) {
            throw new RuntimeException(String.format("Interpreter Error: Invalid key - spaces and %% characters are not allowed: %s", k));
        }
    }

    private ModlParsedVisitor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

