/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ArrayItem;
import uk.modl.utils.IDSource;

public final class ArrayConditionalReturn
implements Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ArrayItem> items;

    public static ArrayConditionalReturn of(Ancestry ancestry, Parent parent, Vector<ArrayItem> items) {
        ArrayConditionalReturn child = ArrayConditionalReturn.of(IDSource.nextId(), items);
        ancestry.add(parent, child);
        return child;
    }

    public ArrayConditionalReturn with(Ancestry ancestry, Vector<ArrayItem> items) {
        ArrayConditionalReturn child = ArrayConditionalReturn.of(this.id, items);
        ancestry.replaceChild(this, child);
        return child;
    }

    private ArrayConditionalReturn(long id, @NonNull Vector<ArrayItem> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.id = id;
        this.items = items;
    }

    public static ArrayConditionalReturn of(long id, @NonNull Vector<ArrayItem> items) {
        return new ArrayConditionalReturn(id, items);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ArrayItem> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayConditionalReturn)) {
            return false;
        }
        ArrayConditionalReturn other = (ArrayConditionalReturn)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "ArrayConditionalReturn(items=" + this.getItems() + ")";
    }
}

