/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Tree<T> {
    private Node<T> root;

    public Tree(T rootData) {
        this.root = new Node<T>(rootData, null, new ArrayList());
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public List<T> getAllNodes() {
        ArrayList result = new ArrayList();
        this.root.addChildData(result);
        return result;
    }

    public static class Node<T> {
        private T data;
        private Node<T> parent;
        private List<Node<T>> children;

        public Node<T> getParent() {
            return this.parent;
        }

        public void addChildren(List<T> newChildren) {
            List newNodes = newChildren.stream().map(t -> new Node<Object>(t, this, new ArrayList<Node<T>>())).collect(Collectors.toList());
            this.children.addAll(newNodes);
        }

        public T getNodeData() {
            return this.data;
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }

        public void addChildData(List<T> result) {
            if (this.data != null && this.data.toString().length() > 0) {
                result.add(this.data);
            }
            this.children.forEach(c -> c.addChildData(result));
        }

        public void addChild(Node<T> node) {
            this.children.add(node);
        }

        public Node(T data, Node<T> parent, List<Node<T>> children) {
            this.data = data;
            this.parent = parent;
            this.children = children;
        }
    }
}

