/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Vector;
import java.util.Objects;
import java.util.function.Predicate;
import uk.modl.ancestry.Child;
import uk.modl.extractors.StarLoadExtractor;
import uk.modl.model.Array;
import uk.modl.model.ArrayConditional;
import uk.modl.model.ArrayConditionalReturn;
import uk.modl.model.ArrayItem;
import uk.modl.model.Condition;
import uk.modl.model.ConditionGroup;
import uk.modl.model.ConditionOrConditionGroupInterface;
import uk.modl.model.ConditionTest;
import uk.modl.model.Map;
import uk.modl.model.MapConditional;
import uk.modl.model.MapConditionalReturn;
import uk.modl.model.MapItem;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.Primitive;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.model.TopLevelConditional;
import uk.modl.model.TopLevelConditionalReturn;
import uk.modl.model.ValueConditional;
import uk.modl.model.ValueConditionalReturn;
import uk.modl.model.ValueItem;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.transforms.ClassExpansionTransform;
import uk.modl.transforms.ConditionalsTransform;
import uk.modl.transforms.LiteralsTransform;
import uk.modl.transforms.PercentStarInstructionTransform;
import uk.modl.transforms.ReferencesTransform;
import uk.modl.transforms.StarClassTransform;
import uk.modl.transforms.StarLoadTransform;
import uk.modl.transforms.StarMethodTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.Util;

public class InterpreterVisitor {
    private final StarLoadTransform starLoadTransform = new StarLoadTransform();
    private final StarClassTransform starClassTransform = new StarClassTransform();
    private final StarMethodTransform starMethodTransform = new StarMethodTransform();
    private final ReferencesTransform referencesTransform = new ReferencesTransform();
    private final ConditionalsTransform conditionalsTransform = new ConditionalsTransform(this.starLoadTransform, this.referencesTransform);
    private final ClassExpansionTransform classExpansionTransform = new ClassExpansionTransform();
    private final PercentStarInstructionTransform percentStarInstructionTransform = new PercentStarInstructionTransform();

    private Tuple2<TransformationContext, Structure> visitStructure(TransformationContext ctx, Structure s) {
        return (Tuple2)API.Match((Object)s).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Map.class)), () -> this.visitMap(ctx, (Map)s)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Array.class)), () -> this.visitArray(ctx, (Array)s)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Pair.class)), () -> this.visitPair(ctx, (Pair)s)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(TopLevelConditional.class)), () -> this.visitTopLevelConditional(ctx, (TopLevelConditional)s)), API.Case((API.Match.Pattern0)API.$(), () -> Tuple.of((Object)ctx, (Object)s))});
    }

    private Tuple2<TransformationContext, Structure> visitTopLevelConditional(TransformationContext ctx, TopLevelConditional tlc) {
        TransformationContext newCtx = ctx;
        Vector tests = Vector.empty();
        for (ConditionTest test : tlc.getTests()) {
            Tuple2<TransformationContext, ConditionTest> result = this.visitConditionTest(newCtx, test);
            newCtx = (TransformationContext)result._1;
            tests = tests.append((Object)((ConditionTest)result._2));
        }
        Vector returns = Vector.empty();
        for (TopLevelConditionalReturn aReturn : tlc.getReturns()) {
            Tuple2<TransformationContext, TopLevelConditionalReturn> result = this.visitTopLevelConditionalReturn(newCtx, aReturn);
            newCtx = (TransformationContext)result._1;
            returns = returns.append((Object)((TopLevelConditionalReturn)result._2));
        }
        Tuple2<TransformationContext, Structure> result = this.conditionalsTransform.apply(newCtx, tlc.with(ctx.getAncestry(), (Vector<ConditionTest>)tests, (Vector<TopLevelConditionalReturn>)returns));
        if (result._2 instanceof TopLevelConditional) {
            TopLevelConditional tlcResult = (TopLevelConditional)result._2;
            if (tlcResult.getResult().size() == 1) {
                return result.update2((Object)((Structure)tlcResult.getResult().get(0)));
            }
            if (tlcResult.getResult().size() > 1) {
                Vector mapItems = tlcResult.getResult().map(s -> {
                    TopLevelConditional topLevelConditional;
                    if (s instanceof MapItem) {
                        return (MapItem)((Object)s);
                    }
                    if (s instanceof TopLevelConditional && (topLevelConditional = (TopLevelConditional)s).getResult().size() > 0) {
                        return (MapItem)topLevelConditional.getResult().get(0);
                    }
                    return null;
                }).filter(Objects::nonNull);
                Map mapResult = Map.of(ctx.getAncestry(), tlc, (Vector<MapItem>)mapItems);
                return result.update2((Object)mapResult);
            }
        }
        return result;
    }

    private Tuple2<TransformationContext, MapItem> visitMapConditional(TransformationContext ctx, MapConditional mc) {
        TransformationContext newCtx = ctx;
        Vector tests = Vector.empty();
        for (ConditionTest test : mc.getTests()) {
            Tuple2<TransformationContext, ConditionTest> result = this.visitConditionTest(newCtx, test);
            newCtx = (TransformationContext)result._1;
            tests = tests.append((Object)((ConditionTest)result._2));
        }
        Vector returns = Vector.empty();
        for (MapConditionalReturn aReturn : mc.getReturns()) {
            Tuple2<TransformationContext, MapConditionalReturn> result = this.visitMapConditionalReturn(newCtx, aReturn);
            newCtx = (TransformationContext)result._1;
            returns = returns.append((Object)((MapConditionalReturn)result._2));
        }
        MapConditional mapConditional = mc.with(ctx.getAncestry(), (Vector<ConditionTest>)tests, (Vector<MapConditionalReturn>)returns);
        MapConditional evaluated = this.conditionalsTransform.apply(newCtx, mapConditional);
        if (evaluated.getResult().nonEmpty()) {
            return Tuple.of((Object)newCtx, (Object)((MapItem)evaluated.getResult().get(0)));
        }
        return Tuple.of((Object)newCtx, (Object)evaluated);
    }

    private Tuple2<TransformationContext, MapConditionalReturn> visitMapConditionalReturn(TransformationContext ctx, MapConditionalReturn mcr) {
        TransformationContext newCtx = ctx;
        Vector items = Vector.empty();
        for (MapItem item : mcr.getItems()) {
            if (item instanceof Pair && StarLoadExtractor.isLoadInstruction(((Pair)item).getKey())) {
                ValueItem refsResult = this.referencesTransform.apply(newCtx, (ValueItem)((Object)item));
                items = items.append((Object)((MapItem)((Object)refsResult)));
                continue;
            }
            Tuple2<TransformationContext, MapItem> result = this.visitMapItem(newCtx, item);
            newCtx = (TransformationContext)result._1;
            items = items.append((Object)((MapItem)result._2));
        }
        return Tuple.of((Object)newCtx, (Object)mcr.with(ctx.getAncestry(), (Vector<MapItem>)items));
    }

    private Tuple2<TransformationContext, TopLevelConditionalReturn> visitTopLevelConditionalReturn(TransformationContext ctx, TopLevelConditionalReturn tlcr) {
        TransformationContext newCtx = ctx;
        Vector structures = Vector.empty();
        for (Structure structure : tlcr.getStructures()) {
            if (structure instanceof Pair && StarLoadExtractor.isLoadInstruction(((Pair)structure).getKey())) {
                Tuple2<TransformationContext, Structure> refsResult = this.referencesTransform.apply(newCtx, structure);
                structures = structures.append((Object)((Structure)refsResult._2));
                newCtx = (TransformationContext)refsResult._1;
                continue;
            }
            if (structure instanceof TopLevelConditional) {
                Tuple2<TransformationContext, Structure> visitResult = this.visitTopLevelConditional(newCtx, (TopLevelConditional)structure);
                newCtx = (TransformationContext)visitResult._1;
                structures = structures.append((Object)((Structure)visitResult._2));
                continue;
            }
            if (structure instanceof Pair && ((Pair)structure).getValue() instanceof ValueConditional) {
                Pair p = (Pair)structure;
                Tuple2<TransformationContext, ValueItem> visitResult = this.visitValueConditional(newCtx, (ValueConditional)p.getValue());
                newCtx = (TransformationContext)visitResult._1;
                structures = structures.append((Object)p.with(ctx.getAncestry(), (PairValue)visitResult._2));
                continue;
            }
            structures = structures.append((Object)structure);
        }
        return Tuple.of((Object)newCtx, (Object)tlcr.with(ctx.getAncestry(), (Vector<Structure>)structures));
    }

    private Tuple2<TransformationContext, ConditionTest> visitConditionTest(TransformationContext ctx, ConditionTest ct) {
        TransformationContext newCtx = ctx;
        Vector newConditions = Vector.empty();
        for (Tuple2 c : ct.getConditions()) {
            Object result;
            if (c._1 instanceof Condition) {
                result = this.visitCondition(newCtx, (Condition)c._1);
                newCtx = (TransformationContext)result._1;
                newConditions = newConditions.append((Object)c.update1((Object)((ConditionOrConditionGroupInterface)result._2)));
                continue;
            }
            result = this.visitConditionGroup(newCtx, (ConditionGroup)c._1);
            newCtx = (TransformationContext)result._1;
            newConditions = newConditions.append((Object)c.update1((Object)((ConditionOrConditionGroupInterface)result._2)));
        }
        return Tuple.of((Object)newCtx, (Object)ct.with(ctx.getAncestry(), (Vector<Tuple2<ConditionOrConditionGroupInterface, String>>)newConditions));
    }

    private Tuple2<TransformationContext, ConditionGroup> visitConditionGroup(TransformationContext ctx, ConditionGroup cg) {
        TransformationContext newCtx = ctx;
        Vector subConditionList = Vector.empty();
        for (Tuple2 subCond : cg.getSubConditionList()) {
            Tuple2<TransformationContext, ConditionTest> result = this.visitConditionTest(newCtx, (ConditionTest)subCond._1);
            newCtx = (TransformationContext)result._1;
            subConditionList = subConditionList.append((Object)subCond.update1((Object)((ConditionTest)result._2)));
        }
        return Tuple.of((Object)newCtx, (Object)cg.with(ctx.getAncestry(), (Vector<Tuple2<ConditionTest, String>>)subConditionList, cg.isShouldNegate()));
    }

    private Tuple2<TransformationContext, Condition> visitCondition(TransformationContext ctx, Condition c) {
        Condition c2 = this.referencesTransform.apply(ctx, c);
        TransformationContext newCtx = ctx;
        Tuple2<TransformationContext, ValueItem> result = this.visitValue(newCtx, c2.getLhs());
        newCtx = (TransformationContext)result._1;
        Primitive newLhs = (Primitive)result._2;
        Vector values = Vector.empty();
        for (ValueItem value : c2.getValues()) {
            Tuple2<TransformationContext, ValueItem> valueResult = this.visitValue(newCtx, value);
            newCtx = (TransformationContext)valueResult._1;
            values = values.append((Object)((ValueItem)valueResult._2));
        }
        return Tuple.of((Object)newCtx, (Object)c.with(ctx.getAncestry(), newLhs, c2.getOp(), (Vector<ValueItem>)values, c2.isShouldNegate()));
    }

    private Tuple2<TransformationContext, Structure> visitArray(TransformationContext ctx, Array arr) {
        TransformationContext newCtx = ctx;
        Vector items = Vector.empty();
        for (ArrayItem arrayItem : arr.getArrayItems()) {
            Tuple2<TransformationContext, ArrayItem> result = this.visitArrayItem(newCtx, arrayItem);
            if (result == null) continue;
            newCtx = (TransformationContext)result._1;
            items = items.append((Object)((ArrayItem)result._2));
        }
        return Tuple.of((Object)newCtx, (Object)arr.with(ctx.getAncestry(), (Vector<ArrayItem>)items));
    }

    private Tuple2<TransformationContext, ArrayItem> visitArrayItem(TransformationContext ctx, ArrayItem ai) {
        if (ai instanceof ArrayConditional) {
            Tuple2<TransformationContext, ArrayItem> result = this.visitArrayConditional(ctx, (ArrayConditional)ai);
            ctx.getAncestry().replaceSubTree(ai, (Child)result._2);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ArrayItem)result._2));
        }
        return this.visitArrayValueItem(ctx, ai);
    }

    private Tuple2<TransformationContext, ArrayItem> visitArrayValueItem(TransformationContext ctx, ArrayItem ai) {
        if (ai instanceof Array) {
            Tuple2<TransformationContext, Structure> result = this.visitArray(ctx, (Array)ai);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ArrayItem)result._2));
        }
        if (ai instanceof Map) {
            Tuple2<TransformationContext, Structure> result = this.visitMap(ctx, (Map)ai);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ArrayItem)result._2));
        }
        if (ai instanceof Pair) {
            Tuple2<TransformationContext, Structure> result = this.visitPair(ctx, (Pair)ai);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ArrayItem)result._2));
        }
        if (ai instanceof Primitive) {
            return Tuple.of((Object)ctx, (Object)((ArrayItem)((Object)this.visitPrimitive(ctx, (Primitive)ai))));
        }
        return null;
    }

    private Tuple2<TransformationContext, ArrayItem> visitArrayConditional(TransformationContext ctx, ArrayConditional ac) {
        TransformationContext newCtx = ctx;
        Vector tests = Vector.empty();
        for (ConditionTest test : ac.getTests()) {
            Tuple2<TransformationContext, ConditionTest> result = this.visitConditionTest(newCtx, test);
            newCtx = (TransformationContext)result._1;
            tests = tests.append((Object)((ConditionTest)result._2));
        }
        Vector returns = Vector.empty();
        for (ArrayConditionalReturn aReturn : ac.getReturns()) {
            Tuple2<TransformationContext, ArrayConditionalReturn> result = this.visitArrayConditionalReturn(newCtx, aReturn);
            newCtx = (TransformationContext)result._1;
            returns = returns.append((Object)((ArrayConditionalReturn)result._2));
        }
        ArrayConditional arrayConditional = ac.with(ctx.getAncestry(), (Vector<ConditionTest>)tests, (Vector<ArrayConditionalReturn>)returns);
        ArrayConditional evaluated = this.conditionalsTransform.apply(newCtx, arrayConditional);
        if (evaluated.getResult().nonEmpty()) {
            return Tuple.of((Object)newCtx, (Object)((ArrayItem)evaluated.getResult().get(0)));
        }
        return Tuple.of((Object)newCtx, (Object)evaluated);
    }

    private Tuple2<TransformationContext, ArrayConditionalReturn> visitArrayConditionalReturn(TransformationContext ctx, ArrayConditionalReturn acr) {
        TransformationContext newCtx = ctx;
        Vector items = Vector.empty();
        for (ArrayItem item : acr.getItems()) {
            if (item instanceof Pair && StarLoadExtractor.isLoadInstruction(((Pair)item).getKey())) {
                ValueItem refsResult = this.referencesTransform.apply(newCtx, (ValueItem)((Object)item));
                items = items.append((Object)((ArrayItem)((Object)refsResult)));
                continue;
            }
            Tuple2<TransformationContext, ArrayItem> result = this.visitArrayItem(newCtx, item);
            newCtx = (TransformationContext)result._1;
            items = items.append((Object)((ArrayItem)result._2));
        }
        return Tuple.of((Object)newCtx, (Object)acr.with(ctx.getAncestry(), (Vector<ArrayItem>)items));
    }

    private Tuple2<TransformationContext, Structure> visitMap(TransformationContext ctx, Map map) {
        Vector items = Vector.empty();
        TransformationContext newCtx = ctx;
        for (MapItem mapItem : map.getMapItems()) {
            Tuple2<TransformationContext, MapItem> result = this.visitMapItem(newCtx, mapItem);
            items = items.append((Object)((MapItem)result._2));
            newCtx = (TransformationContext)result._1;
        }
        return Tuple.of((Object)newCtx, (Object)map.with(ctx.getAncestry(), (Vector<MapItem>)items));
    }

    private Tuple2<TransformationContext, MapItem> visitMapItem(TransformationContext ctx, MapItem mi) {
        if (mi instanceof Pair) {
            Tuple2<TransformationContext, Structure> result = this.visitPair(ctx, (Pair)mi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((MapItem)result._2));
        }
        Tuple2<TransformationContext, MapItem> result = this.visitMapConditional(ctx, (MapConditional)mi);
        ctx.getAncestry().replaceSubTree(mi, (Child)result._2);
        return Tuple.of((Object)((TransformationContext)result._1), (Object)((MapItem)result._2));
    }

    private Tuple2<TransformationContext, Structure> visitPair(TransformationContext ctx, Pair p) {
        if (Util.isInvalidKeyword(p.getKey())) {
            throw new RuntimeException("Invalid keyword: " + p.getKey());
        }
        TransformationContext newCtx = ctx;
        newCtx = this.checkForVersionInstruction(p, newCtx);
        if (StarLoadExtractor.isLoadInstruction(p.getKey())) {
            ValueItem result = this.referencesTransform.apply(newCtx, (ValueItem)p.getValue());
            Tuple2<TransformationContext, Structure> structureWithLoadedFiles = this.starLoadTransform.apply(newCtx, p.with(ctx.getAncestry(), result));
            return Tuple.of((Object)((TransformationContext)structureWithLoadedFiles._1), (Object)((Structure)structureWithLoadedFiles._2));
        }
        Tuple2<TransformationContext, Structure> structureWithExpandedClasses = this.starClassTransform.apply(newCtx, p);
        Tuple2<TransformationContext, Structure> structureWithAppliedMethods = this.starMethodTransform.apply((TransformationContext)structureWithExpandedClasses._1, (Structure)structureWithExpandedClasses._2);
        Tuple2<TransformationContext, Structure> contextAndStructure = this.referencesTransform.apply((TransformationContext)structureWithAppliedMethods._1, (Structure)structureWithAppliedMethods._2);
        Structure structure = (Structure)contextAndStructure._2;
        newCtx = (TransformationContext)contextAndStructure._1;
        if (structure != null) {
            Object result;
            PairValue value;
            if (structure instanceof Pair) {
                Pair pair = (Pair)structure;
                value = pair.getValue();
            } else {
                value = (PairValue)((Object)structure);
            }
            if (value instanceof Array) {
                result = this.visitArray(newCtx, (Array)value);
                newCtx = (TransformationContext)result._1;
                value = (PairValue)result._2;
            } else if (value instanceof Map) {
                result = this.visitMap(newCtx, (Map)value);
                newCtx = (TransformationContext)result._1;
                value = (PairValue)result._2;
            } else if (value instanceof ValueItem) {
                result = this.visitValueItem(newCtx, (ValueItem)value);
                newCtx = (TransformationContext)result._1;
                value = (PairValue)result._2;
            }
            if (structure instanceof Pair) {
                Pair newPair = p.with(ctx.getAncestry(), value);
                return Tuple.of((Object)newCtx, (Object)newPair);
            }
        }
        return Tuple.of((Object)newCtx, (Object)structure);
    }

    private TransformationContext checkForVersionInstruction(Pair p, TransformationContext newCtx) {
        if (this.isVersionKey(p)) {
            try {
                int version = p.getValue().numericValue().intValue();
                if (version <= 0) {
                    throw new RuntimeException("Invalid MODL version: " + p.getValue().toString());
                }
                newCtx = newCtx.withVersion(version);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid MODL version: " + p.getValue().toString());
            }
        }
        return newCtx;
    }

    private boolean isVersionKey(Pair p) {
        return p.getKey().equals("*VERSION") || p.getKey().equals("*V");
    }

    private Tuple2<TransformationContext, ValueItem> visitValueItem(TransformationContext ctx, ValueItem vi) {
        if (vi instanceof ValueConditional) {
            Tuple2<TransformationContext, ValueItem> result = this.visitValueConditional(ctx, (ValueConditional)vi);
            ctx.getAncestry().replaceSubTree(vi, (Child)result._2);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        if (vi instanceof Map) {
            Tuple2<TransformationContext, Structure> result = this.visitMap(ctx, (Map)vi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        if (vi instanceof Array) {
            Tuple2<TransformationContext, Structure> result = this.visitArray(ctx, (Array)vi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        if (vi instanceof Pair) {
            Tuple2<TransformationContext, Structure> result = this.visitPair(ctx, (Pair)vi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        if (vi instanceof Primitive) {
            Primitive primitive = (Primitive)this.visitPrimitive(ctx, (Primitive)vi);
            return Tuple.of((Object)ctx, (Object)primitive);
        }
        return Tuple.of((Object)ctx, (Object)vi);
    }

    private Tuple2<TransformationContext, ValueItem> visitValueConditional(TransformationContext ctx, ValueConditional vc) {
        TransformationContext newCtx = ctx;
        Vector tests = Vector.empty();
        for (ConditionTest test : vc.getTests()) {
            Tuple2<TransformationContext, ConditionTest> result = this.visitConditionTest(newCtx, test);
            newCtx = (TransformationContext)result._1;
            tests = tests.append((Object)((ConditionTest)result._2));
        }
        Vector returns = Vector.empty();
        for (ValueConditionalReturn aReturn : vc.getReturns()) {
            Tuple2<TransformationContext, ValueConditionalReturn> result = this.visitValueConditionReturn(newCtx, aReturn);
            returns = returns.append((Object)((ValueConditionalReturn)result._2));
            newCtx = (TransformationContext)result._1;
        }
        ValueConditional valueConditional = vc.with(ctx.getAncestry(), (Vector<ConditionTest>)tests, (Vector<ValueConditionalReturn>)returns);
        ValueConditional evaluated = this.conditionalsTransform.apply(newCtx, valueConditional);
        if (evaluated.getResult().nonEmpty()) {
            return Tuple.of((Object)newCtx, (Object)((ValueItem)evaluated.getResult().get(0)));
        }
        return Tuple.of((Object)newCtx, (Object)evaluated);
    }

    private Tuple2<TransformationContext, ValueConditionalReturn> visitValueConditionReturn(TransformationContext ctx, ValueConditionalReturn vcr) {
        TransformationContext newCtx = ctx;
        Vector items = Vector.empty();
        for (ValueItem item : vcr.getItems()) {
            if (item instanceof Pair && StarLoadExtractor.isLoadInstruction(((Pair)item).getKey())) {
                ValueItem refsResult = this.referencesTransform.apply(newCtx, item);
                items = items.append((Object)refsResult);
                continue;
            }
            Tuple2<TransformationContext, ValueItem> result = this.visitValueItem(newCtx, item);
            newCtx = (TransformationContext)result._1;
            items = items.append((Object)((ValueItem)result._2));
        }
        return Tuple.of((Object)newCtx, (Object)vcr.with(ctx.getAncestry(), (Vector<ValueItem>)items));
    }

    private Tuple2<TransformationContext, ValueItem> visitValue(TransformationContext ctx, ValueItem vi) {
        if (vi instanceof StringPrimitive) {
            ValueItem newValueItem = this.referencesTransform.apply(ctx, vi);
            return this.visitValueItem(ctx, newValueItem);
        }
        if (vi instanceof Array) {
            Tuple2<TransformationContext, Structure> result = this.visitArray(ctx, (Array)vi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        if (vi instanceof Map) {
            Tuple2<TransformationContext, Structure> result = this.visitMap(ctx, (Map)vi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        if (vi instanceof Pair) {
            Tuple2<TransformationContext, Structure> result = this.visitPair(ctx, (Pair)vi);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)((ValueItem)result._2));
        }
        return Tuple.of((Object)ctx, (Object)vi);
    }

    private ValueItem visitPrimitive(TransformationContext ctx, Primitive prim) {
        ValueItem dereferenced = this.referencesTransform.apply(ctx, prim);
        if (dereferenced instanceof StringPrimitive) {
            StringPrimitive stringPrimitive = (StringPrimitive)dereferenced;
            return stringPrimitive.with(ctx.getAncestry(), LiteralsTransform.replacellLiteralRefs(stringPrimitive.getValue()));
        }
        return dereferenced;
    }

    public Tuple2<TransformationContext, Modl> apply(TransformationContext ctx, Modl modl) {
        TransformationContext newCtx = ctx;
        try {
            Vector visitedStructures = Vector.empty();
            for (Structure structure2 : modl.getStructures()) {
                Tuple2<TransformationContext, Structure> result = this.visitStructure(newCtx, structure2);
                ctx.getAncestry().replaceSubTree(structure2, (Child)result._2);
                newCtx = (TransformationContext)result._1;
                visitedStructures = visitedStructures.append((Object)((Structure)result._2));
                modl.with(ctx.getAncestry(), (Vector<Structure>)visitedStructures);
            }
            TransformationContext finalNewCtx = newCtx;
            Vector resultStructures = visitedStructures.map(structure -> {
                Structure expanded = this.classExpansionTransform.apply(finalNewCtx, (Structure)structure);
                return this.percentStarInstructionTransform.apply(finalNewCtx, null, expanded);
            });
            Modl updatedModl = modl.with(ctx.getAncestry(), (Vector<Structure>)resultStructures.filter(Objects::nonNull));
            return Tuple.of((Object)finalNewCtx, (Object)updatedModl);
        }
        catch (InterpreterError e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (newCtx.getVersion() > 1) {
                throw new InterpreterError("Interpreter Error: " + e.getMessage() + " - MODL Version 1 interpreter cannot process this MODL Version " + newCtx.getVersion() + " file.");
            }
            throw new InterpreterError("Interpreter Error: " + e.getMessage());
        }
    }
}

