/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ArrayItem;
import uk.modl.model.MapItem;
import uk.modl.model.PairValue;
import uk.modl.model.Structure;
import uk.modl.model.ValueItem;
import uk.modl.utils.IDSource;

public final class Map
implements PairValue,
Structure,
ValueItem,
ArrayItem,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<MapItem> mapItems;

    public static Map of(Ancestry ancestry, Parent parent, Vector<MapItem> mapItems) {
        Map child = Map.of(IDSource.nextId(), mapItems);
        ancestry.add(parent, child);
        return child;
    }

    @Override
    public Number numericValue() {
        throw new RuntimeException("Cannot convert a map to a numeric value.");
    }

    public Map with(Ancestry ancestry, Vector<MapItem> mapItems) {
        Map child = Map.of(this.id, mapItems);
        ancestry.replaceChild(this, child);
        return child;
    }

    private Map(long id, @NonNull Vector<MapItem> mapItems) {
        if (mapItems == null) {
            throw new NullPointerException("mapItems is marked non-null but is null");
        }
        this.id = id;
        this.mapItems = mapItems;
    }

    public static Map of(long id, @NonNull Vector<MapItem> mapItems) {
        return new Map(id, mapItems);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<MapItem> getMapItems() {
        return this.mapItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "Map(mapItems=" + this.getMapItems() + ")";
    }
}

