/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ArrayItem;
import uk.modl.model.PairValue;
import uk.modl.model.Structure;
import uk.modl.model.ValueItem;
import uk.modl.utils.IDSource;

public final class Array
implements PairValue,
Structure,
ValueItem,
ArrayItem,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ArrayItem> arrayItems;

    public static Array of(Ancestry ancestry, Parent parent, Vector<ArrayItem> arrayItems) {
        Array child = Array.of(IDSource.nextId(), arrayItems);
        ancestry.add(parent, child);
        return child;
    }

    @Override
    public Number numericValue() {
        throw new RuntimeException("Cannot convert an array to a numeric value.");
    }

    public Array with(Ancestry ancestry, Vector<ArrayItem> arrayItems) {
        Array child = Array.of(this.id, arrayItems);
        ancestry.replaceChild(this, child);
        return child;
    }

    private Array(long id, @NonNull Vector<ArrayItem> arrayItems) {
        if (arrayItems == null) {
            throw new NullPointerException("arrayItems is marked non-null but is null");
        }
        this.id = id;
        this.arrayItems = arrayItems;
    }

    public static Array of(long id, @NonNull Vector<ArrayItem> arrayItems) {
        return new Array(id, arrayItems);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ArrayItem> getArrayItems() {
        return this.arrayItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Array other = (Array)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "Array(arrayItems=" + this.getArrayItems() + ")";
    }
}

