/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.collection.Vector;
import java.net.IDN;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import uk.modl.extractors.StarLoadExtractor;
import uk.modl.model.PairValue;
import uk.modl.model.ValueItem;

public final class Util {
    public static final String INVALID_CHARS = "!$-+'#^*\u00a3&";
    private static final Pattern METHODS_PATTERN = Pattern.compile("replace<[^.]*>|r<[^.]*>|t<[^<>]+>|trim<[^<>]+>|initcap|[^.]\\w+|\\w|u|e|p|s|i|d|[^%.][0-9]+");
    private static final Pattern replacerPattern = Pattern.compile("^replace<(.*),(.*)>$|^r<(.*),(.*)>$");
    private static final Pattern trimmerPattern = Pattern.compile("^trim<(.*)>$|^t<(.*)>$");

    public static String jsonNodeToString(JsonNode jsonNode) {
        try {
            return new ObjectMapper().writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unquote(String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("`") && text.endsWith("`")) {
            return StringUtils.unwrap((String)text, (String)"`");
        }
        return StringUtils.unwrap((String)text, (String)"\"");
    }

    public static String replacer(String spec, String s) {
        Matcher matcher = replacerPattern.matcher(spec);
        if (matcher.find()) {
            String text = matcher.group(1) != null ? matcher.group(1) : matcher.group(3);
            String rep = matcher.group(2) != null ? matcher.group(2) : matcher.group(4);
            String newText = Util.unquote(rep);
            String oldtext = Util.unquote(text);
            return s.replace(oldtext, newText);
        }
        throw new RuntimeException("Invalid method: " + spec);
    }

    public static String trimmer(String spec, String s) {
        Matcher matcher = trimmerPattern.matcher(spec);
        if (matcher.find()) {
            String text = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            int i = s.indexOf(text);
            if (i > -1) {
                return s.substring(0, i);
            }
        } else {
            throw new RuntimeException("Invalid method: " + spec);
        }
        return s;
    }

    public static boolean greaterThanAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) <= v2;
        }).isDefined();
    }

    private static double toDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid numeric value: " + e.getMessage());
        }
    }

    public static boolean greaterThanOrEqualToAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) < v2;
        }).isDefined();
    }

    public static boolean lessThanAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) >= v2;
        }).isDefined();
    }

    public static boolean lessThanOrEqualToAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) > v2;
        }).isDefined();
    }

    public static boolean truthy(PairValue value) {
        if (value != null) {
            String s = value.toString();
            return !s.equalsIgnoreCase("null") && !s.equalsIgnoreCase("000") && !s.equalsIgnoreCase("00") && !s.equalsIgnoreCase("false");
        }
        return false;
    }

    public static String handleMethodsAndTrailingPathComponents(String[] refList, String valueStr) {
        String[] stringArray = refList;
        int n = stringArray.length;
        block24: for (int i = 0; i < n; ++i) {
            String pathComponent;
            switch (pathComponent = stringArray[i]) {
                case "p": 
                case "punydecode": {
                    valueStr = Util.replacePunycode(Util.unquote(valueStr));
                    continue block24;
                }
                case "u": 
                case "upcase": {
                    valueStr = Util.unquote(valueStr).toUpperCase();
                    continue block24;
                }
                case "d": 
                case "downcase": {
                    valueStr = Util.unquote(valueStr).toLowerCase();
                    continue block24;
                }
                case "i": 
                case "initcap": {
                    valueStr = WordUtils.capitalize((String)Util.unquote(valueStr));
                    continue block24;
                }
                case "s": 
                case "sentence": {
                    valueStr = StringUtils.capitalize((String)Util.unquote(valueStr));
                    continue block24;
                }
                case "e": 
                case "urlencode": {
                    try {
                        valueStr = URLEncoder.encode(valueStr, StandardCharsets.UTF_8.toString());
                        continue block24;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error processing URL encoding instruction: " + e.getMessage());
                    }
                }
                default: {
                    if (pathComponent.startsWith("r<") || pathComponent.startsWith("replace<")) {
                        valueStr = Util.replacer(pathComponent, valueStr);
                        continue block24;
                    }
                    if (!pathComponent.startsWith("t<") && !pathComponent.startsWith("trim<")) continue block24;
                    valueStr = Util.trimmer(pathComponent, valueStr);
                }
            }
        }
        return valueStr;
    }

    public static String replacePunycode(String s) {
        if (s == null) {
            return null;
        }
        return IDN.toUnicode("xn--" + s);
    }

    public static Vector<String> toMethodList(String chainedMethods) {
        Matcher matcher = METHODS_PATTERN.matcher(chainedMethods);
        Vector methods = Vector.empty();
        while (matcher.find()) {
            methods = methods.append((Object)matcher.group(0));
        }
        return methods;
    }

    public static StarLoadExtractor.FileSpec normalize(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String normalized = text;
        if (normalized.length() > 1 && normalized.startsWith("`") && normalized.endsWith("`")) {
            normalized = StringUtils.unwrap((String)normalized, (String)"`");
        } else if (normalized.length() > 1 && normalized.startsWith("\"") && normalized.endsWith("\"")) {
            normalized = StringUtils.unwrap((String)normalized, (String)"\"");
        }
        boolean forceLoad = normalized.endsWith("!");
        normalized = StringUtils.removeEnd((String)normalized, (String)"!");
        if (!normalized.endsWith(".modl") && !normalized.endsWith(".txt")) {
            normalized = normalized + ".modl";
        }
        normalized = normalized.replace("~://", "://");
        return StarLoadExtractor.FileSpec.of(normalized, forceLoad);
    }

    public static String unwrapLiteral(String literal) {
        if (literal == null || !literal.startsWith("%`")) {
            return literal;
        }
        return StringUtils.unwrap((String)literal.substring(1), (String)"`");
    }

    public static void validatePairKey(String newKey) {
        String k = Util.maybeStripLeadingSpecialCharacter(newKey);
        int badCharIndex = StringUtils.indexOfAny((CharSequence)k, (String)INVALID_CHARS);
        if (badCharIndex > -1) {
            throw new RuntimeException("Invalid key - \"" + k.charAt(badCharIndex) + "\" character not allowed: " + newKey);
        }
        if (StringUtils.isNumeric((CharSequence)k)) {
            throw new RuntimeException("Invalid key - \"" + k + "\" - entirely numeric keys are not allowed: " + newKey);
        }
    }

    private static String maybeStripLeadingSpecialCharacter(String newKey) {
        return newKey.startsWith("_") || newKey.startsWith("*") ? newKey.substring(1) : newKey;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

