/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Vector;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.Pair;
import uk.modl.model.Structure;
import uk.modl.transforms.ReferencesTransform;
import uk.modl.transforms.TransformationContext;

public class StarClassTransform {
    private static final Vector<String> RESERVED_CLASS_NAMES = Vector.of((Object[])new String[]{"arr", "map", "str", "num", "bool", "null"});
    private final ReferencesTransform referencesTransform = new ReferencesTransform();

    public static boolean isClassInstruction(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return StringUtils.equalsAnyIgnoreCase((CharSequence)key, (CharSequence[])new CharSequence[]{"*c", "*class"});
    }

    public Tuple2<TransformationContext, Structure> apply(TransformationContext ctx, @NonNull Structure p) {
        Pair pair;
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (p instanceof Pair && StarClassTransform.isClassInstruction((pair = (Pair)p).getKey())) {
            TransformationContext updatedContext = this.accept(ctx, pair);
            return Tuple.of((Object)updatedContext, null);
        }
        return Tuple.of((Object)ctx, (Object)p);
    }

    private TransformationContext accept(TransformationContext ctx, @NonNull Pair pair) {
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        if (pair.getValue() instanceof Map) {
            String id = null;
            String name = null;
            String superclass = null;
            Vector assign = Vector.empty();
            LinkedHashMap pairs = LinkedHashMap.empty();
            for (MapItem mi : ((Map)pair.getValue()).getMapItems()) {
                if (mi instanceof Pair) {
                    Pair p = (Pair)mi;
                    switch (p.getKey().toLowerCase()) {
                        case "*i": 
                        case "*id": {
                            id = p.getValue().toString();
                            break;
                        }
                        case "*n": 
                        case "*name": {
                            name = p.getValue().toString();
                            break;
                        }
                        case "*s": 
                        case "*superclass": {
                            superclass = p.getValue().toString();
                            break;
                        }
                        case "*a": 
                        case "*assign": {
                            if (p.getValue() instanceof Array) {
                                assign = ((Array)p.getValue()).getArrayItems().map(ai -> {
                                    if (ai instanceof Array) {
                                        return ai;
                                    }
                                    throw new RuntimeException("*assign statement should be an Array of Arrays");
                                });
                                break;
                            }
                            throw new RuntimeException("*assign statement should be an Array of Arrays");
                        }
                        default: {
                            if (p.getValue().toString().contains("%")) {
                                Tuple2<TransformationContext, Structure> result = this.referencesTransform.apply(ctx, p);
                                pairs = pairs.put((Object)p.getKey(), (Object)((Pair)result._2));
                                break;
                            }
                            pairs = pairs.put((Object)p.getKey(), (Object)p);
                            break;
                        }
                    }
                    continue;
                }
                throw new RuntimeException("Expected a Pair but found a " + mi.getClass());
            }
            this.validateAssign((Vector<ArrayItem>)assign);
            if (id != null && RESERVED_CLASS_NAMES.contains((Object)id.toLowerCase())) {
                throw new RuntimeException("Reserved class id - cannot redefine: " + id);
            }
            if (name != null && RESERVED_CLASS_NAMES.contains((Object)name.toLowerCase())) {
                throw new RuntimeException("Reserved class name - cannot redefine: " + name);
            }
            TransformationContext newCtx = ctx.addClassInstruction(ClassInstruction.of(id, name, superclass, (Vector<ArrayItem>)assign, (io.vavr.collection.Map<String, Pair>)pairs));
            if (pair.getKey().startsWith("*C")) {
                newCtx = newCtx.withStarClassImmutable(true);
            }
            return newCtx;
        }
        throw new RuntimeException("Expected a map for " + pair.getKey() + " but found a " + pair.getValue().getClass());
    }

    private void validateAssign(Vector<ArrayItem> assigns) {
        int lastLen = 0;
        for (ArrayItem assign : assigns) {
            Array array = (Array)assign;
            @NonNull Vector<ArrayItem> arrayItems = array.getArrayItems();
            if (arrayItems.size() <= lastLen) {
                Vector strings = arrayItems.map(ai -> "\"" + ai.toString() + "\"").intersperse((Object)", ");
                String arrayStr = (String)strings.foldLeft((Object)"[", (l, r) -> l + r) + "]";
                throw new RuntimeException("Error: Key lists in *assign are not in ascending order of list length: " + arrayStr);
            }
            lastLen = arrayItems.size();
        }
    }

    public static final class ClassInstruction {
        @NonNull
        private final String id;
        private final String name;
        private final String superclass;
        @NonNull
        private final Vector<ArrayItem> assign;
        @NonNull
        private final io.vavr.collection.Map<String, Pair> pairs;

        final String getNameOrId() {
            return this.name == null ? this.id : this.name;
        }

        private ClassInstruction(@NonNull String id, String name, String superclass, @NonNull Vector<ArrayItem> assign, @NonNull io.vavr.collection.Map<String, Pair> pairs) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (assign == null) {
                throw new NullPointerException("assign is marked non-null but is null");
            }
            if (pairs == null) {
                throw new NullPointerException("pairs is marked non-null but is null");
            }
            this.id = id;
            this.name = name;
            this.superclass = superclass;
            this.assign = assign;
            this.pairs = pairs;
        }

        public static ClassInstruction of(@NonNull String id, String name, String superclass, @NonNull Vector<ArrayItem> assign, @NonNull io.vavr.collection.Map<String, Pair> pairs) {
            return new ClassInstruction(id, name, superclass, assign, pairs);
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSuperclass() {
            return this.superclass;
        }

        @NonNull
        public Vector<ArrayItem> getAssign() {
            return this.assign;
        }

        @NonNull
        public io.vavr.collection.Map<String, Pair> getPairs() {
            return this.pairs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassInstruction)) {
                return false;
            }
            ClassInstruction other = (ClassInstruction)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$superclass = this.getSuperclass();
            String other$superclass = other.getSuperclass();
            if (this$superclass == null ? other$superclass != null : !this$superclass.equals(other$superclass)) {
                return false;
            }
            Vector<ArrayItem> this$assign = this.getAssign();
            Vector<ArrayItem> other$assign = other.getAssign();
            if (this$assign == null ? other$assign != null : !this$assign.equals(other$assign)) {
                return false;
            }
            io.vavr.collection.Map<String, Pair> this$pairs = this.getPairs();
            io.vavr.collection.Map<String, Pair> other$pairs = other.getPairs();
            return !(this$pairs == null ? other$pairs != null : !this$pairs.equals(other$pairs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $superclass = this.getSuperclass();
            result = result * 59 + ($superclass == null ? 43 : $superclass.hashCode());
            Vector<ArrayItem> $assign = this.getAssign();
            result = result * 59 + ($assign == null ? 43 : $assign.hashCode());
            io.vavr.collection.Map<String, Pair> $pairs = this.getPairs();
            result = result * 59 + ($pairs == null ? 43 : $pairs.hashCode());
            return result;
        }

        public String toString() {
            return "StarClassTransform.ClassInstruction(id=" + this.getId() + ", name=" + this.getName() + ", superclass=" + this.getSuperclass() + ", assign=" + this.getAssign() + ", pairs=" + this.getPairs() + ")";
        }
    }
}

