/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import uk.modl.interpreter.Interpreter;
import uk.modl.interpreter.Util;
import uk.modl.interpreter.VariableMethods;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

public class StringTransformer {
    private Map<String, ModlValue> valuePairs;
    private Map<String, ModlValue> variables;
    private Map<Integer, ModlValue> numberedVariables;

    StringTransformer(Map<String, ModlValue> valuePairs, Map<String, ModlValue> variables, Map<Integer, ModlValue> numberedVariables) {
        this.valuePairs = valuePairs;
        this.variables = variables;
        this.numberedVariables = numberedVariables;
    }

    public static List<String> getPercentPartsFromString(String stringToTransform) {
        LinkedList<String> percentParts = new LinkedList<String>();
        int currentIndex = 0;
        boolean finished = false;
        while (!finished) {
            int endIndex;
            finished = true;
            int startIndex = StringTransformer.getNextPercent(stringToTransform, currentIndex);
            if (startIndex <= -1) continue;
            if (startIndex < stringToTransform.length() - 1) {
                endIndex = StringTransformer.getReferenceEndIndex(stringToTransform, startIndex);
                if (endIndex > stringToTransform.length()) {
                    endIndex = stringToTransform.length();
                }
            } else {
                if (startIndex == stringToTransform.length() - 1) {
                    return percentParts;
                }
                endIndex = StringTransformer.getEndOfNumber(stringToTransform, startIndex + 1);
            }
            if (endIndex == -1) continue;
            if (endIndex > startIndex + 1) {
                String gravePart = stringToTransform.substring(startIndex, endIndex);
                percentParts.add(gravePart);
                currentIndex = endIndex;
            } else if (endIndex == startIndex + 1) {
                finished = true;
                continue;
            }
            finished = false;
        }
        return percentParts;
    }

    private static int getReferenceEndIndex(String stringToTransform, int startIndex) {
        int endIndex = 99999;
        boolean inMethodParams = false;
        boolean inGraves = false;
        String endChars = " :%!<,>";
        char prev = '\u0000';
        for (int i = startIndex + 1; i < stringToTransform.length(); ++i) {
            char c = stringToTransform.charAt(i);
            if (c == '<') {
                inMethodParams = true;
            } else if (c == '>') {
                inMethodParams = false;
            } else if (c == '`') {
                if (!inGraves && !inMethodParams && i > startIndex + 1) {
                    endIndex = i;
                    break;
                }
                inGraves = !inGraves;
            } else if (" :%!<,>".indexOf(c) > -1 && !inGraves && !inMethodParams && prev != '.') {
                endIndex = i;
                if (c != '%') break;
                ++endIndex;
                break;
            }
            prev = c;
        }
        if (endIndex > stringToTransform.length()) {
            endIndex = stringToTransform.length();
        }
        return endIndex;
    }

    private static int getEndOfNumber(String stringToTransform, int startIndex) {
        char nextChar;
        int currentIndex = startIndex;
        if (currentIndex == stringToTransform.length()) {
            return currentIndex;
        }
        while (Character.isDigit(stringToTransform.charAt(currentIndex))) {
            if (++currentIndex != stringToTransform.length()) continue;
            return currentIndex;
        }
        String cAfterNumber = stringToTransform.substring(currentIndex, currentIndex + 1);
        if (!cAfterNumber.equals(".")) {
            if (cAfterNumber.equals("%")) {
                return currentIndex + 1;
            }
            return currentIndex;
        }
        do {
            if (++currentIndex <= stringToTransform.length() - 1) continue;
            return currentIndex;
        } while ((nextChar = stringToTransform.charAt(currentIndex)) == '.' || Character.isLetterOrDigit(nextChar));
        return currentIndex;
    }

    private static int getNextPercent(String stringToTransform, int startIndex) {
        int searchFrom = startIndex;
        int i;
        while ((i = stringToTransform.indexOf("%", searchFrom)) > 0) {
            char c = stringToTransform.charAt(i - 1);
            if (c != '\\' && c != '~') {
                return i;
            }
            searchFrom = i + 1;
        }
        return i;
    }

    ModlValue transformString(String stringToTransform) {
        if (stringToTransform == null) {
            return null;
        }
        List<String> graveParts = this.getGravePartsFromString(stringToTransform);
        for (String gravePart : graveParts) {
            if (gravePart.startsWith("`%")) {
                ModlValue ret = this.runObjectReferencing(gravePart, stringToTransform, true);
                if (ret instanceof ModlObject.String) {
                    String retStr = ((ModlObject.String)ret).string;
                    if (retStr.equals(stringToTransform)) {
                        stringToTransform = retStr;
                    } else {
                        stringToTransform = retStr;
                        String nonGravePart = gravePart.substring(1, gravePart.length() - 1);
                        stringToTransform = stringToTransform.replace(gravePart, nonGravePart);
                    }
                    stringToTransform = Util.degrave(stringToTransform);
                    continue;
                }
                if (ret instanceof ModlObject.Number) {
                    if (gravePart.equals(stringToTransform)) {
                        return ret;
                    }
                    String number = ((ModlObject.Number)ret).number;
                    stringToTransform = stringToTransform.replace(gravePart, number);
                    continue;
                }
                return ret;
            }
            stringToTransform = Util.degrave(stringToTransform);
        }
        List<String> percentParts = StringTransformer.getPercentPartsFromString(stringToTransform);
        for (String percentPart : percentParts) {
            ModlValue ret = this.runObjectReferencing(percentPart, stringToTransform, false);
            if (ret instanceof ModlObject.String) {
                ModlObject.String theString = (ModlObject.String)ret;
                if (stringToTransform.equals(theString.string) && !stringToTransform.startsWith("%*") && stringToTransform.contains(".") && stringToTransform.contains("%") && stringToTransform.indexOf("%") == stringToTransform.lastIndexOf("%")) {
                    throw new RuntimeException("Interpreter Error: Cannot resolve reference in: \"" + stringToTransform + "\"");
                }
                stringToTransform = theString.string;
                continue;
            }
            if (ret instanceof ModlObject.Number) {
                if (percentPart.equals(stringToTransform)) {
                    return ret;
                }
                String number = ((ModlObject.Number)ret).number;
                stringToTransform = stringToTransform.replace(percentPart, number);
                continue;
            }
            return ret;
        }
        return new ModlObject.String(stringToTransform);
    }

    private List<String> getGravePartsFromString(String stringToTransform) {
        LinkedList<String> graveParts = new LinkedList<String>();
        int currentIndex = 0;
        boolean finished = false;
        while (!finished) {
            int endIndex;
            finished = true;
            int startIndex = this.getNextNonPrefixedGrave(stringToTransform, currentIndex);
            if (startIndex <= -1 || (endIndex = this.getNextNonPrefixedGrave(stringToTransform, startIndex + 1)) <= -1) continue;
            String gravePart = stringToTransform.substring(startIndex, endIndex + 1);
            graveParts.add(gravePart);
            currentIndex = endIndex + 1;
            finished = false;
        }
        return graveParts;
    }

    private int getNextNonPrefixedGrave(String stringToTransform, int startIndex) {
        int index = stringToTransform.indexOf("`", startIndex);
        if (index == -1) {
            return -1;
        }
        if (index > startIndex) {
            String prefix = stringToTransform.substring(index - 1, index);
            if (prefix.equals("~") || prefix.equals("\\")) {
                return this.getNextNonPrefixedGrave(stringToTransform, index + 1);
            }
            return index;
        }
        return startIndex;
    }

    ModlValue runObjectReferencing(String originalPercentPart, String stringToTransform, boolean isGraved) {
        String percentPart = originalPercentPart;
        int startOffset = 1;
        int endOffset = 0;
        if (isGraved) {
            ++startOffset;
            ++endOffset;
        }
        if (percentPart.endsWith("%")) {
            percentPart = percentPart.substring(0, percentPart.length() - 1);
        }
        String subject = percentPart.substring(startOffset, percentPart.length() - endOffset);
        String remainder = null;
        int indexOfDot = percentPart.indexOf(".");
        if (indexOfDot != -1) {
            subject = percentPart.substring(startOffset, indexOfDot);
            remainder = percentPart.substring(indexOfDot + 1, percentPart.length() - endOffset);
        }
        if (subject.startsWith("`") && subject.endsWith("`") && subject.length() > 1) {
            subject = subject.substring(1, subject.length() - 1);
        } else {
            ModlValue value = this.getValueForReference(subject);
            if (remainder != null) {
                String[] remainderHolder = new String[]{remainder};
                value = this.getValueForReferenceRecursive(value, remainderHolder);
                remainder = remainderHolder[0];
            }
            if (value == null) {
                return new ModlObject.String(stringToTransform);
            }
            if (value instanceof ModlObject.String) {
                subject = ((ModlObject.String)value).string;
            } else if (value instanceof ModlObject.Number) {
                if (remainder == null) {
                    return value;
                }
                subject = ((ModlObject.Number)value).number;
            } else {
                return value;
            }
        }
        if (remainder != null) {
            subject = this.runMethods(subject, remainder);
        }
        if (isGraved) {
            originalPercentPart = originalPercentPart.substring(1, originalPercentPart.length() - 1);
            stringToTransform = stringToTransform.replaceFirst(originalPercentPart, subject);
        } else {
            stringToTransform = stringToTransform.replaceFirst(originalPercentPart, subject);
        }
        return new ModlObject.String(stringToTransform);
    }

    private String runMethods(String subject, String remainder) {
        String[] methods = remainder.split("\\.");
        if (methods.length == 0) {
            methods = new String[]{remainder};
        }
        boolean stalled = false;
        for (String method : methods) {
            if (!stalled) {
                if (method.contains("<")) {
                    int startParamsIndex = method.indexOf("<");
                    String paramsString = method.substring(startParamsIndex + 1, method.length() - 1);
                    String methodString = method.substring(0, startParamsIndex);
                    subject = Interpreter.variableMethods.transform(methodString, subject + "," + paramsString);
                    remainder = null;
                    continue;
                }
                if (!Interpreter.variableMethods.isVariableMethod(method)) {
                    subject = subject + "." + method;
                    remainder = "";
                    stalled = true;
                    continue;
                }
                Matcher matcher = VariableMethods.STRING.matcher(method);
                if (!matcher.find() || matcher.groupCount() <= 0) continue;
                String match = matcher.group(0);
                remainder = method.substring(match.length());
                if (!match.equals(method)) {
                    method = match;
                }
                subject = Interpreter.variableMethods.transform(method, subject);
                continue;
            }
            remainder = remainder + "." + method;
        }
        if (remainder != null) {
            subject = subject + remainder;
        }
        return subject;
    }

    private ModlValue getValueForReference(String subject) {
        String remainder;
        boolean isNested;
        int indexOfGreaterThanSymbol = subject.indexOf(".");
        boolean bl = isNested = indexOfGreaterThanSymbol > -1;
        if (isNested) {
            remainder = subject.substring(indexOfGreaterThanSymbol + 1);
            subject = subject.substring(0, indexOfGreaterThanSymbol);
        } else {
            remainder = null;
        }
        ModlValue value = null;
        boolean found = false;
        for (int i = 0; i < this.numberedVariables.size(); ++i) {
            if (!subject.equals(Integer.toString(i))) continue;
            value = this.numberedVariables.get(i);
            found = true;
            break;
        }
        if (!found) {
            for (Map.Entry<String, ModlValue> variableEntry : this.variables.entrySet()) {
                if (!subject.equals(variableEntry.getKey())) continue;
                value = variableEntry.getValue();
                found = true;
                break;
            }
        }
        if (!found) {
            for (Map.Entry<String, ModlValue> variableEntry : this.valuePairs.entrySet()) {
                if (!subject.equals(variableEntry.getKey()) && !subject.equals("_" + variableEntry.getKey())) continue;
                value = variableEntry.getValue();
                break;
            }
        }
        if (value != null && isNested) {
            return this.getValueForReferenceRecursive(value, new String[]{remainder});
        }
        return value;
    }

    private ModlValue getValueForReferenceRecursive(ModlValue ctx, String[] keyHolder) {
        ModlValue newCtx;
        String currentKey;
        String remainder;
        boolean isNested;
        String key = keyHolder[0];
        int indexOfGreaterThanSymbol = key.indexOf(".");
        boolean bl = isNested = indexOfGreaterThanSymbol > -1;
        if (isNested) {
            remainder = key.substring(indexOfGreaterThanSymbol + 1);
            currentKey = key.substring(0, indexOfGreaterThanSymbol);
        } else {
            keyHolder[0] = remainder = null;
            currentKey = key;
        }
        if (StringUtils.isNumeric((CharSequence)currentKey)) {
            if (!(ctx instanceof ModlObject.Array)) {
                throw new RuntimeException("Object reference is numerical for non-Array value");
            }
            int index = Integer.parseInt(currentKey);
            newCtx = ctx.get(index);
        } else {
            currentKey = ((ModlObject.String)this.transformString((String)currentKey)).string;
            if (ctx instanceof ModlObject.Pair) {
                if (!currentKey.equals(((ModlObject.Pair)ctx).getKey().string)) {
                    throw new RuntimeException("Object reference should match the key name for a Pair");
                }
                newCtx = ((ModlObject.Pair)ctx).getModlValue();
            } else if (ctx instanceof ModlObject.Map || ctx instanceof ModlObject.Array) {
                newCtx = ctx.get(currentKey);
            } else {
                keyHolder[0] = key;
                newCtx = ctx;
                isNested = false;
            }
        }
        if (isNested) {
            keyHolder[0] = remainder;
            return this.getValueForReferenceRecursive(newCtx, keyHolder);
        }
        if (newCtx == null) {
            keyHolder[0] = currentKey;
        }
        return newCtx;
    }
}

